/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item.map;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Dbl;
import org.basex.query.item.Empty;
import org.basex.query.item.FItem;
import org.basex.query.item.Flt;
import org.basex.query.item.FuncType;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.MapType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.item.map.TrieNode;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;

public final class Map
extends FItem {
    public static final Map EMPTY = new Map(TrieNode.EMPTY);
    static final int BITS = 5;
    private final TrieNode root;
    private Value keys;
    private Itr size;

    public Map(TrieNode m) {
        super(MapType.ANY_MAP);
        this.root = m;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public QNm fName() {
        return null;
    }

    @Override
    public Value invValue(QueryContext ctx, InputInfo ii, Value ... args) throws QueryException {
        return this.get(args[0].item(ctx, ii), ii);
    }

    private Item key(Item it, InputInfo ii) throws QueryException {
        if (it == null) {
            throw Err.XPEMPTY.thrw(ii, this.desc());
        }
        if (it instanceof FItem) {
            throw Err.FNATM.thrw(ii, it.desc());
        }
        if (it == Flt.NAN || it == Dbl.NAN) {
            return null;
        }
        return it.type.unt() ? Str.get(it.atom(ii)) : it;
    }

    public Map delete(Item key, InputInfo ii) throws QueryException {
        Item k = this.key(key, ii);
        if (k == null) {
            return this;
        }
        TrieNode del = this.root.delete(k.hash(ii), k, 0, ii);
        return del == this.root ? this : (del != null ? new Map(del) : EMPTY);
    }

    public Value get(Item key, InputInfo ii) throws QueryException {
        Item k = this.key(key, ii);
        if (k == null) {
            return Empty.SEQ;
        }
        Value val = this.root.get(k.hash(ii), k, 0, ii);
        return val == null ? Empty.SEQ : val;
    }

    public Bln contains(Item k, InputInfo ii) throws QueryException {
        Item key = this.key(k, ii);
        return Bln.get(key != null && this.root.contains(key.hash(ii), key, 0, ii));
    }

    public Map addAll(Map other, InputInfo ii) throws QueryException {
        if (other == EMPTY) {
            return this;
        }
        TrieNode upd = this.root.addAll(other.root, 0, ii);
        return upd == other.root ? other : new Map(upd);
    }

    public boolean hasType(MapType t) {
        return this.root.hasType(t.keyType == AtomType.AAT ? null : t.keyType, t.ret.eq(SeqType.ITEM_ZM) ? null : t.ret);
    }

    @Override
    public Map coerceTo(FuncType ft, QueryContext ctx, InputInfo ii) throws QueryException {
        if (!(ft instanceof MapType) || !this.hasType((MapType)ft)) {
            throw Err.cast(ii, ft, this);
        }
        return this;
    }

    public Map insert(Item k, Value v, InputInfo ii) throws QueryException {
        Item key = this.key(k, ii);
        if (key == null) {
            return this;
        }
        TrieNode ins = this.root.insert(key.hash(ii), key, v, 0, ii);
        return ins == this.root ? this : new Map(ins);
    }

    public static Map entry(Item k, Value val, InputInfo ii) throws QueryException {
        return EMPTY.insert(k, val, ii);
    }

    public Itr mapSize() {
        if (this.size == null) {
            this.size = Itr.get(this.root.size);
        }
        return this.size;
    }

    public Value keys() {
        if (this.keys == null) {
            ItemCache res = new ItemCache(this.root.size);
            this.root.keys(res);
            this.keys = res.finish();
        }
        return this.keys;
    }

    public Str collation() {
        return Str.get(QueryText.URLCOLL);
    }

    public boolean deep(InputInfo ii, Map o) throws QueryException {
        return this.root.deep(ii, o.root);
    }

    public TokenObjMap<Object> tokenJavaMap(InputInfo ii) throws QueryException {
        Item k;
        TokenObjMap<Object> tm = new TokenObjMap<Object>();
        ValueIter vi = this.keys().iter();
        while ((k = vi.next()) != null) {
            if (!k.str()) {
                Err.FUNCMP.thrw(ii, this.desc(), AtomType.STR, k.type);
            }
            tm.add(k.atom(null), this.get(k, ii).toJava());
        }
        return tm;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return this.root.hash(ii);
    }

    @Override
    public String desc() {
        return "map{...}";
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        long s = this.mapSize().itr(null);
        ser.openElement(QueryText.MAP, (byte[][])new byte[][]{QueryText.SIZE, Token.token(s)});
        Value ks = this.keys();
        try {
            long i = 0L;
            long max = Math.min(s, 5L);
            while (i < max) {
                Item key = ks.itemAt(i);
                Value val = this.get(key, null);
                ser.openElement(QueryText.ENTRY, (byte[][])new byte[][]{QueryText.KEY, key.atom(null)});
                val.plan(ser);
                ser.closeElement();
                ++i;
            }
        }
        catch (QueryException ex) {
            Util.notexpected(ex);
        }
        ser.closeElement();
    }

    @Override
    public String toString() {
        StringBuilder sb = this.root.toString(new StringBuilder("map{ "));
        if (this.root.size > 0) {
            sb.deleteCharAt(sb.length() - 2);
        }
        return sb.append("}").toString();
    }
}

