/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.Num;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Dec
extends Num {
    private static final Dec ZERO = new Dec(BigDecimal.ZERO);
    private final BigDecimal val;

    public Dec(byte[] t) {
        super(AtomType.DEC);
        this.val = new BigDecimal(Token.string(Token.trim(t)));
    }

    public Dec(BigDecimal d, Type t) {
        super(t);
        this.val = d;
    }

    private Dec(BigDecimal d) {
        super(AtomType.DEC);
        this.val = d;
    }

    public static Dec get(BigDecimal d) {
        return d.signum() == 0 ? ZERO : new Dec(d);
    }

    public static Dec get(double d) {
        return Dec.get(BigDecimal.valueOf(d));
    }

    @Override
    public byte[] atom(InputInfo ii) {
        return Token.chopNumber(Token.token(this.val.toPlainString()));
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.val.signum() != 0;
    }

    @Override
    public long itr(InputInfo ii) {
        return this.val.longValue();
    }

    @Override
    public float flt(InputInfo ii) {
        return this.val.floatValue();
    }

    @Override
    public double dbl(InputInfo ii) {
        return this.val.doubleValue();
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.val;
    }

    @Override
    public boolean eq(InputInfo ii, Item it) throws QueryException {
        return it.type == AtomType.DBL || it.type == AtomType.FLT ? it.eq(ii, this) : this.val.compareTo(it.dec(ii)) == 0;
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        double d = it.dbl(ii);
        return d == Double.POSITIVE_INFINITY ? -1 : (d == Double.NEGATIVE_INFINITY ? 1 : (Double.isNaN(d) ? Integer.MIN_VALUE : this.val.compareTo(it.dec(ii))));
    }

    @Override
    public Object toJava() {
        return this.type == AtomType.ULN ? new BigInteger(this.val.toString()) : this.val;
    }

    static BigDecimal parse(double val, InputInfo ii) throws QueryException {
        if (Double.isNaN(val) || val == Double.POSITIVE_INFINITY || val == Double.NEGATIVE_INFINITY) {
            Err.value(ii, AtomType.DEC, val);
        }
        return BigDecimal.valueOf(val);
    }

    static BigDecimal parse(byte[] val, InputInfo ii) throws QueryException {
        if (Token.contains(val, 101) || Token.contains(val, 69)) {
            Err.FUNCAST.thrw(ii, AtomType.DEC, val);
        }
        try {
            return new BigDecimal(Token.string(val).trim());
        }
        catch (NumberFormatException ex) {
            throw ZERO.castErr(val, ii);
        }
    }
}

