/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.item.DBNode;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.Seq;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.iter.ValueIter;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class DBNodeSeq
extends Seq {
    public final Data data;
    public final int[] pres;
    public boolean complete;

    private DBNodeSeq(int[] p, Data d, Type t, boolean c) {
        super(p.length, t);
        this.pres = p;
        this.data = d;
        this.complete = c;
    }

    public static Value get(IntList v, Data d, boolean docs, boolean c) {
        int s = v.size();
        return s == 0 ? Empty.SEQ : (s == 1 ? new DBNode(d, v.get(0)) : new DBNodeSeq(v.toArray(), d, docs ? NodeType.DOC : NodeType.NOD, c));
    }

    @Override
    public Data data() {
        return this.data;
    }

    @Override
    public Object toJava() {
        Object[] obj = new Object[(int)this.size];
        int s = 0;
        while ((long)s != this.size) {
            obj[s] = this.itemAt(s).toJava();
            ++s;
        }
        return obj;
    }

    @Override
    public ValueIter iter() {
        return new ValueIter(){
            int c = -1;

            @Override
            public Item next() {
                return (long)(++this.c) < DBNodeSeq.this.size ? DBNodeSeq.this.itemAt(this.c) : null;
            }

            @Override
            public Item get(long i) {
                return DBNodeSeq.this.itemAt((int)i);
            }

            @Override
            public long size() {
                return DBNodeSeq.this.size;
            }

            @Override
            public boolean reset() {
                this.c = -1;
                return true;
            }

            @Override
            public Value finish() {
                return DBNodeSeq.this;
            }
        };
    }

    @Override
    public Item ebv(QueryContext ctx, InputInfo ii) {
        return this.itemAt(0L);
    }

    @Override
    public SeqType type() {
        return SeqType.NOD_OM;
    }

    @Override
    public boolean iterable() {
        return true;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof DBNodeSeq)) {
            return false;
        }
        DBNodeSeq seq = (DBNodeSeq)cmp;
        return this.pres == seq.pres && this.size == seq.size;
    }

    @Override
    public int writeTo(Item[] arr, int start) {
        int i = 0;
        while (i < this.pres.length) {
            arr[i + start] = this.itemAt(i);
            ++i;
        }
        return this.pres.length;
    }

    @Override
    public DBNode itemAt(long pos) {
        return new DBNode(this.data, this.pres[(int)pos]);
    }

    @Override
    public boolean homogenous() {
        return false;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(Token.token(Util.name(this)), (byte[][])new byte[][]{QueryText.SIZE, Token.token(this.size)});
        int v = 0;
        while ((long)v != Math.min(this.size, 5L)) {
            this.itemAt(v).plan(ser);
            ++v;
        }
        ser.closeElement();
    }
}

