/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.B64;
import org.basex.query.item.Dbl;
import org.basex.query.item.Hex;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.ItrSeq;
import org.basex.query.item.Str;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class FNUtil
extends FuncCall {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final BigInteger MAX_ULONG = BigInteger.ONE.shiftLeft(64);

    public FNUtil(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case EVAL: {
                return this.eval(ctx).iter();
            }
            case RUN: {
                return this.run(ctx).iter();
            }
            case TO_BYTES: {
                return this.bytes(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case EVAL: {
                return this.eval(ctx);
            }
            case RUN: {
                return this.run(ctx);
            }
            case TO_BYTES: {
                return this.bytes(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case FORMAT: {
                return this.format(ctx);
            }
            case MB: {
                return this.mb(ctx);
            }
            case MS: {
                return this.ms(ctx);
            }
            case FRM_BASE: {
                return this.fromBase(ctx, ii);
            }
            case TO_BASE: {
                return this.toBase(ctx, ii);
            }
            case MD5: {
                return this.hash(ctx, "MD5");
            }
            case SHA1: {
                return this.hash(ctx, "SHA");
            }
            case CRC32: {
                return this.crc32(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Value eval(QueryContext ctx) throws QueryException {
        return this.eval(ctx, this.checkEStr(this.expr[0], ctx));
    }

    private Value eval(QueryContext ctx, byte[] qu) throws QueryException {
        QueryContext qt = new QueryContext(ctx.context);
        qt.parse(Token.string(qu));
        qt.compile();
        return qt.value();
    }

    private Value run(QueryContext ctx) throws QueryException {
        IO io = this.checkIO(this.expr[0], ctx);
        try {
            return this.eval(ctx, io.content());
        }
        catch (IOException ex) {
            throw Err.NODOC.thrw(this.input, ex);
        }
    }

    private Value bytes(QueryContext ctx) throws QueryException {
        byte[] bytes = ((B64)this.checkType(this.expr[0].item(ctx, this.input), AtomType.B64)).toJava();
        int bl = bytes.length;
        long[] tmp = new long[bl];
        int i = 0;
        while (i < bl) {
            tmp[i] = bytes[i];
            ++i;
        }
        return ItrSeq.get(tmp, AtomType.BYT);
    }

    private Str format(QueryContext ctx) throws QueryException {
        String form = Token.string(this.checkStr(this.expr[0], ctx));
        Object[] args = new Object[this.expr.length - 1];
        int e = 1;
        while (e < this.expr.length) {
            args[e - 1] = this.expr[e].item(ctx, this.input).toJava();
            ++e;
        }
        try {
            return Str.get(String.format(form, args));
        }
        catch (RuntimeException ex) {
            throw Err.ERRFORM.thrw(this.input, Util.name(ex), ex.getMessage());
        }
    }

    private Dbl mb(QueryContext ctx) throws QueryException {
        boolean c = this.expr.length == 2 && this.checkType(this.expr[1].item(ctx, this.input), AtomType.BLN).bool(this.input);
        Performance.gc(3);
        long l = Performance.mem();
        Value val = ctx.value(this.expr[0]);
        if (c) {
            val = val.cache().finish();
        }
        Performance.gc(2);
        double d = Performance.mem() - l;
        ValueIter ir = val.iter();
        while (((Iter)ir).next() != null) {
        }
        return Dbl.get(Math.max(0.0, d) / 1024.0 / 1024.0);
    }

    private Dbl ms(QueryContext ctx) throws QueryException {
        boolean c = this.expr.length == 2 && this.checkType(this.expr[1].item(ctx, this.input), AtomType.BLN).bool(this.input);
        Performance p = new Performance();
        if (c) {
            ctx.value(this.expr[0]).cache();
        } else {
            Iter ir = ctx.iter(this.expr[0]);
            while (ir.next() != null) {
            }
        }
        return Dbl.get((double)(p.getTime() / 10000L) / 100.0);
    }

    private Str toBaseFast(long num, int shift) {
        byte[] bytes = new byte[(64 + shift - 1) / shift];
        int mask = (1 << shift) - 1;
        long n = num;
        int pos = bytes.length;
        do {
            bytes[--pos] = DIGITS[(int)(n & (long)mask)];
        } while ((n >>>= shift) != 0L);
        return Str.get(Token.substring(bytes, pos));
    }

    private Str toBase(QueryContext ctx, InputInfo ii) throws QueryException {
        long num = this.checkItr(this.expr[0], ctx);
        long base = this.checkItr(this.expr[1], ctx);
        if (base < 2L || base > 36L) {
            Err.INVBASE.thrw(ii, base);
        }
        int i = 1;
        int p = 2;
        while (i < 6) {
            if (base == (long)p) {
                return this.toBaseFast(num, i);
            }
            ++i;
            p <<= 1;
        }
        ByteList tb = new ByteList();
        long n = num;
        if (n < 0L) {
            BigInteger[] dr = BigInteger.valueOf(n).add(MAX_ULONG).divideAndRemainder(BigInteger.valueOf(base));
            n = dr[0].longValue();
            tb.add(DIGITS[dr[1].intValue()]);
        } else {
            tb.add(DIGITS[(int)(n % base)]);
            n /= base;
        }
        while (n != 0L) {
            tb.add(DIGITS[(int)(n % base)]);
            n /= base;
        }
        byte[] res = tb.toArray();
        Array.reverse(res);
        return Str.get(res);
    }

    private Itr fromBase(QueryContext ctx, InputInfo ii) throws QueryException {
        byte[] str = this.checkStr(this.expr[0], ctx);
        long base = this.checkItr(this.expr[1], ctx);
        if (base < 2L || base > 36L) {
            Err.INVBASE.thrw(ii, base);
        }
        long res = 0L;
        byte[] byArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            int num;
            byte b = byArray[n2];
            int n3 = num = b <= 57 ? b - 48 : (b & 0xDF) - 55;
            if (!((b >= 48 && b <= 57 || b >= 97 && b <= 122 || b >= 65 && b <= 90) && (long)num < base)) {
                Err.INVDIG.thrw(ii, base, Character.valueOf((char)(b & 0xFF)));
            }
            res = res * base + (long)num;
            ++n2;
        }
        return Itr.get(res);
    }

    private Hex hash(QueryContext ctx, String algo) throws QueryException {
        byte[] str = this.checkStr(this.expr[0], ctx);
        try {
            return new Hex(MessageDigest.getInstance(algo).digest(str));
        }
        catch (NoSuchAlgorithmException ex) {
            throw Util.notexpected(ex);
        }
    }

    private Hex crc32(QueryContext ctx) throws QueryException {
        CRC32 crc = new CRC32();
        crc.update(this.checkStr(this.expr[0], ctx));
        byte[] res = new byte[4];
        int i = res.length;
        int c = (int)crc.getValue();
        while (i-- > 0) {
            res[i] = (byte)(c & 0xFF);
            c >>>= 8;
        }
        return new Hex(res);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && (this.def == Function.EVAL || this.def == Function.RUN || this.def == Function.MB || this.def == Function.MS) || super.uses(u);
    }
}

