/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.HashMap;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.query.util.SentList;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;

public final class FNSent
extends FuncCall {
    private static final HashMap<String, SentList> LISTS = new HashMap();

    public FNSent(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case SENT: {
                return this.polarity(ctx, false);
            }
            case SENTNORM: {
                return this.polarity(ctx, true);
            }
        }
        return super.item(ctx, ii);
    }

    private Item polarity(QueryContext ctx, boolean norm) throws QueryException {
        byte[] str = this.checkStr(this.expr[0], ctx);
        String uri = Token.string(this.checkStr(this.expr[1], ctx));
        SentList list = LISTS.get(uri);
        if (list == null) {
            try {
                list = new SentList(uri);
                LISTS.put(uri, list);
            }
            catch (Exception ex) {
                throw Err.DOCERR.thrw(this.input, uri);
            }
        }
        double pos = 0.0;
        double neg = 0.0;
        byte[] token1 = Token.EMPTY;
        byte[] token2 = Token.EMPTY;
        byte[] token3 = Token.EMPTY;
        byte[] token4 = Token.EMPTY;
        FTOpt fto = new FTOpt();
        fto.set(FTFlag.ST, true);
        FTLexer tk = new FTLexer(fto).init(str);
        while (tk.hasNext()) {
            token4 = token3;
            token3 = token2;
            token2 = token1;
            token1 = tk.nextToken();
            double v = list.polarity(token1);
            if (list.negates(token2) || list.negates(token3) || list.negates(token4)) {
                v = -v;
            }
            if (v > 0.0) {
                pos += v;
                continue;
            }
            if (!(v < 0.0)) continue;
            neg -= v;
        }
        double result = pos - neg;
        if (norm && result != 0.0) {
            result = -1.0 + pos * 2.0 / (pos + neg);
        }
        return Dbl.get(result);
    }
}

