/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.basex.core.Prop;
import org.basex.core.cmd.Copy;
import org.basex.io.IOFile;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNGen;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.B64;
import org.basex.query.item.Bln;
import org.basex.query.item.Dtm;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Str;
import org.basex.query.item.Uri;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class FNFile
extends FuncCall {
    public FNFile(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkAdmin(ctx);
        switch (this.def) {
            case FLIST: {
                return this.list(ctx);
            }
            case READLINES: {
                return this.readTextLines(new File(Token.string(this.checkStr(this.expr[0], ctx))), ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkAdmin(ctx);
        File path = this.expr.length == 0 ? null : new File(Token.string(this.checkStr(this.expr[0], ctx)));
        switch (this.def) {
            case APPEND: {
                return this.write(path, ctx, true);
            }
            case APPENDBIN: {
                return this.writeBinary(path, ctx, true);
            }
            case COPY: {
                return this.transfer(path, ctx, true);
            }
            case CREATEDIR: {
                return this.createDirectory(path);
            }
            case DELETE: {
                return this.del(path);
            }
            case MOVE: {
                return this.transfer(path, ctx, false);
            }
            case READBIN: {
                return this.readBinary(path);
            }
            case READTEXT: {
                return this.readText(path, ctx);
            }
            case WRITE: {
                return this.write(path, ctx, false);
            }
            case WRITEBIN: {
                return this.writeBinary(path, ctx, false);
            }
            case FEXISTS: {
                return Bln.get(path.exists());
            }
            case ISDIR: {
                return Bln.get(path.isDirectory());
            }
            case ISFILE: {
                return Bln.get(path.isFile());
            }
            case LASTMOD: {
                return this.lastModified(path);
            }
            case SIZE: {
                return this.size(path);
            }
            case BASENAME: {
                return this.baseName(path, ctx);
            }
            case DIRNAME: {
                return this.dirName(path);
            }
            case PATHNATIVE: {
                return this.pathToNative(path);
            }
            case RESOLVEPATH: {
                return Str.get(path.getAbsolutePath());
            }
            case PATHTOURI: {
                return this.pathToUri(path);
            }
        }
        return super.item(ctx, ii);
    }

    private Item lastModified(File path) throws QueryException {
        if (!path.exists()) {
            Err.PATHNOTEXISTS.thrw(this.input, path);
        }
        return new Dtm(path.lastModified(), this.input);
    }

    private Item size(File path) throws QueryException {
        if (!path.exists()) {
            Err.PATHNOTEXISTS.thrw(this.input, path);
        }
        if (path.isDirectory()) {
            Err.PATHISDIR.thrw(this.input, path);
        }
        return Itr.get(path.length());
    }

    private Str baseName(File path, QueryContext ctx) throws QueryException {
        if (path.getPath().length() == 0) {
            return Str.get(".");
        }
        String suf = this.expr.length < 2 ? null : Token.string(this.checkStr(this.expr[1], ctx));
        String pth = path.getName();
        if (suf != null && pth.endsWith(suf)) {
            pth = pth.substring(0, pth.length() - suf.length());
        }
        return Str.get(pth);
    }

    private Str dirName(File path) {
        String pth = path.getParent();
        return Str.get(pth == null ? "." : pth);
    }

    private Str pathToNative(File path) throws QueryException {
        try {
            return Str.get(path.getCanonicalFile());
        }
        catch (IOException ex) {
            throw Err.PATHINVALID.thrw(this.input, path);
        }
    }

    private Uri pathToUri(File path) {
        return Uri.uri(Token.token(path.toURI().toString()));
    }

    private Iter list(QueryContext ctx) throws QueryException {
        String path = Token.string(this.checkStr(this.expr[0], ctx));
        File dir = new File(path);
        if (!dir.isDirectory()) {
            Err.NOTDIR.thrw(this.input, path);
        }
        boolean rec = this.optionalBool(1, ctx);
        Pattern pat = this.expr.length != 3 ? null : Pattern.compile(IOFile.regex(Token.string(this.checkStr(this.expr[2], ctx))), Prop.WIN ? 2 : 0);
        final StringList list = new StringList();
        this.list(dir, list, rec, pat);
        return new Iter(){
            int c = -1;

            @Override
            public Item next() {
                return ++this.c < list.size() ? Str.get(list.get(this.c)) : null;
            }
        };
    }

    private void list(File dir, StringList list, boolean rec, Pattern pat) {
        File f;
        int n;
        int n2;
        File[] fileArray;
        File[] ch = dir.listFiles();
        if (ch == null) {
            return;
        }
        if (rec) {
            fileArray = ch;
            n2 = ch.length;
            n = 0;
            while (n < n2) {
                f = fileArray[n];
                if (f.isDirectory()) {
                    this.list(f, list, rec, pat);
                }
                ++n;
            }
        }
        fileArray = ch;
        n2 = ch.length;
        n = 0;
        while (n < n2) {
            f = fileArray[n];
            if (pat == null || pat.matcher(f.getName()).matches() && !f.isDirectory()) {
                list.add(f.getPath());
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Item createDirectory(File path) throws QueryException {
        f = null;
        try {
            f = path.getCanonicalFile();
            if (true) ** GOTO lbl10
        }
        catch (IOException ex) {
            throw Err.PATHINVALID.thrw(this.input, new Object[]{path});
        }
        do {
            if ((f = f.getParentFile()) != null) continue;
            throw Err.PATHINVALID.thrw(this.input, new Object[]{path});
lbl10:
            // 2 sources

        } while (!f.exists());
        if (f.isFile()) {
            Err.FILEEXISTS.thrw(this.input, new Object[]{path});
        }
        if (!path.exists() && !path.mkdirs()) {
            Err.CANNOTCREATE.thrw(this.input, new Object[]{path});
        }
        return null;
    }

    private Item del(File path) throws QueryException {
        if (!path.exists()) {
            Err.PATHNOTEXISTS.thrw(this.input, path);
        }
        this.deleteRec(path);
        return null;
    }

    private void deleteRec(File path) throws QueryException {
        File[] ch = path.listFiles();
        if (ch != null) {
            File[] fileArray = ch;
            int n = ch.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.deleteRec(f);
                ++n2;
            }
        }
        if (!path.delete()) {
            Err.CANNOTDEL.thrw(this.input, path);
        }
    }

    private B64 readBinary(File path) throws QueryException {
        if (!path.exists()) {
            Err.PATHNOTEXISTS.thrw(this.input, path);
        }
        if (path.isDirectory()) {
            Err.PATHISDIR.thrw(this.input, path);
        }
        try {
            return new B64(new IOFile(path).content());
        }
        catch (IOException ex) {
            throw Err.FILEERROR.thrw(this.input, ex);
        }
    }

    private Str readText(File path, QueryContext ctx) throws QueryException {
        String enc;
        String string = enc = this.expr.length < 2 ? null : Token.string(this.checkStr(this.expr[1], ctx));
        if (!path.exists()) {
            Err.PATHNOTEXISTS.thrw(this.input, path);
        }
        if (path.isDirectory()) {
            Err.PATHISDIR.thrw(this.input, path);
        }
        if (enc != null && !Charset.isSupported(enc)) {
            Err.ENCNOTEXISTS.thrw(this.input, enc);
        }
        try {
            byte[] txt = TextInput.content(new IOFile(path), enc).finish();
            if (Token.contains(txt, 13)) {
                txt = Token.contains(txt, 10) ? Token.delete(txt, 13) : Token.replace(txt, 13, 10);
            }
            return Str.get(txt);
        }
        catch (IOException ex) {
            throw Err.FILEERROR.thrw(this.input, ex);
        }
    }

    private Iter readTextLines(File path, QueryContext ctx) throws QueryException {
        return FNGen.textIter(this.readText(path, ctx).atom());
    }

    private Item write(File path, QueryContext ctx, boolean append) throws QueryException {
        if (path.isDirectory()) {
            Err.PATHISDIR.thrw(this.input, path);
        }
        Iter ir = this.expr[1].iter(ctx);
        try {
            PrintOutput out = PrintOutput.get(new FileOutputStream(path, append));
            try {
                try {
                    Item it;
                    XMLSerializer xml = new XMLSerializer(out, FNGen.serialPar(this, 2, ctx));
                    while ((it = ir.next()) != null) {
                        it.serialize(xml);
                    }
                    xml.close();
                }
                catch (SerializerException ex) {
                    throw new QueryException(this.input, ex);
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            Err.FILEERROR.thrw(this.input, ex);
        }
        return null;
    }

    private Item writeBinary(File path, QueryContext ctx, boolean append) throws QueryException {
        if (path.isDirectory()) {
            Err.PATHISDIR.thrw(this.input, path);
        }
        try {
            FileOutputStream out = new FileOutputStream(path, append);
            try {
                Item it;
                Iter ir = this.expr[1].iter(ctx);
                while ((it = ir.next()) != null) {
                    out.write(((B64)this.checkType(it, AtomType.B64)).toJava());
                }
            }
            finally {
                out.close();
            }
        }
        catch (IOException ex) {
            Err.FILEERROR.thrw(this.input, ex);
        }
        return null;
    }

    private Item transfer(File src, QueryContext ctx, boolean copy) throws QueryException {
        File trg = new File(Token.string(this.checkStr(this.expr[1], ctx))).getAbsoluteFile();
        if (!src.exists()) {
            Err.PATHNOTEXISTS.thrw(this.input, src);
        }
        if (trg.isDirectory()) {
            trg = new File(trg, src.getName());
        } else if (!trg.isFile()) {
            if (!trg.getParentFile().isDirectory()) {
                Err.NOTDIR.thrw(this.input, trg);
            }
        } else if (src.isDirectory()) {
            Err.PATHISDIR.thrw(this.input, src);
        }
        if (!src.equals(trg)) {
            if (copy) {
                this.copy(src, trg);
            } else if (!src.renameTo(trg)) {
                Err.CANNOTMOVE.thrw(this.input, src, trg);
            }
        }
        return null;
    }

    private void copy(File src, File trg) throws QueryException {
        if (src.isDirectory()) {
            File[] files;
            if (!trg.mkdir()) {
                Err.CANNOTCREATE.thrw(this.input, trg);
            }
            if ((files = src.listFiles()) == null) {
                Err.CANNOTLIST.thrw(this.input, src);
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.copy(f, new File(trg, f.getName()));
                ++n2;
            }
        } else {
            try {
                Copy.copy(src, trg);
            }
            catch (IOException ex) {
                Err.FILEERROR.thrw(this.input, ex);
            }
        }
    }

    private boolean optionalBool(int i, QueryContext ctx) throws QueryException {
        return this.expr.length > i && this.checkType(this.expr[i].item(ctx, this.input), AtomType.BLN).bool(this.input);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX || super.uses(u);
    }
}

