/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class UserFunc
extends Single {
    public final QNm name;
    public SeqType ret;
    public final Var[] args;
    public final boolean declared;
    public boolean updating;
    private boolean cast;
    private boolean compiled;

    public UserFunc(InputInfo ii, QNm n, Var[] a, SeqType r, boolean d) {
        super(ii, null);
        this.name = n;
        this.ret = r;
        this.args = a;
        this.declared = d;
        this.cast = r != null;
    }

    public final void check() throws QueryException {
        if (!this.declared || this.expr == null) {
            Err.FUNCUNKNOWN.thrw(this.input, new Object[]{this.name.atom()});
        }
        boolean u = this.expr.uses(Expr.Use.UPD);
        if (this.updating) {
            if (this.ret != null) {
                Err.UPFUNCTYPE.thrw(this.input, new Object[0]);
            }
            if (!u && !this.expr.vacuous()) {
                Err.UPEXPECTF.thrw(this.input, new Object[0]);
            }
        } else if (u) {
            Err.UPNOT.thrw(this.input, this.desc());
        }
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        int s = ctx.vars.size();
        Var[] varArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            ctx.vars.add(v);
            ++n2;
        }
        this.expr = this.expr.comp(ctx);
        ctx.vars.reset(s);
        this.expr.markTailCalls();
        if (this.ret != null && (this.ret.type == AtomType.BLN || this.ret.type == AtomType.FLT || this.ret.type == AtomType.DBL || this.ret.type == AtomType.QNM || this.ret.type == AtomType.URI) && this.ret.eq(this.expr.type())) {
            ctx.compInfo("removing redundant % cast.", this.ret);
            this.cast = false;
        }
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Value cv = ctx.value;
        ctx.value = null;
        Item it = this.expr.item(ctx, ii);
        ctx.value = cv;
        return this.cast ? this.ret.cast(it, this, false, ctx, this.input) : it;
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        Value cv = ctx.value;
        ctx.value = null;
        Value v = this.expr.value(ctx);
        ctx.value = cv;
        return this.cast ? this.ret.promote(v, ctx, this.input) : v;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        ser.attribute(QueryText.NAM, this.name.atom());
        int i = 0;
        while (i < this.args.length) {
            ser.attribute(Token.token("arg" + i), this.args[i].name.atom());
            ++i;
        }
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.name.atom());
        tb.add("(").addSep(this.args, ", ").add(")");
        if (this.ret != null) {
            tb.add(" as " + this.ret);
        }
        if (this.expr != null) {
            tb.add(" { " + this.expr + " }; ");
        }
        return tb.toString();
    }
}

