/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.item.AtomType;
import org.basex.query.item.Dbl;
import org.basex.query.item.Dec;
import org.basex.query.item.Flt;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.SeqType;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Unary
extends Single {
    private final boolean minus;

    public Unary(InputInfo ii, Expr e, boolean min) {
        super(ii, e);
        this.minus = min;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        this.type = this.expr.type();
        if (!this.type.num()) {
            this.type = SeqType.ITR;
        }
        return this.expr.value() ? this.preEval(ctx) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr.item(ctx, this.input);
        if (it == null) {
            return null;
        }
        if (!it.unt() && !it.num()) {
            Err.number(this, it);
        }
        double d = it.dbl(this.input);
        if (it.unt()) {
            return Dbl.get(this.minus ? -d : d);
        }
        if (!this.minus) {
            return it;
        }
        switch ((AtomType)it.type) {
            case DBL: {
                return Dbl.get(-d);
            }
            case FLT: {
                return Flt.get(-it.flt(this.input));
            }
            case DEC: {
                return Dec.get(it.dec(this.input).negate());
            }
        }
        return Itr.get(-it.itr(this.input));
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.VAL, Token.token(this.minus)});
        this.expr.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        return String.valueOf(this.minus ? "-" : "") + this.expr;
    }
}

