/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.func.Function;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Pos
extends Simple {
    final long min;
    final long max;

    private Pos(long mn, long mx, InputInfo ii) {
        super(ii);
        this.min = mn;
        this.max = mx;
        this.type = SeqType.BLN;
    }

    public static Expr get(long mn, long mx, InputInfo ii) {
        return mn > mx || mx < 1L ? Bln.FALSE : (mn <= 1L && mx == Long.MAX_VALUE ? Bln.TRUE : new Pos(mn, mx, ii));
    }

    public static Expr get(CmpV.Op cmp, Expr a, Expr o, InputInfo ii) throws QueryException {
        Item it;
        if (a.isFun(Function.LAST) && cmp == CmpV.Op.EQ) {
            return a;
        }
        if (a.item() && (it = (Item)a).num()) {
            long p = it.itr(ii);
            boolean ex = (double)p == it.dbl(ii);
            switch (cmp) {
                case EQ: {
                    return ex ? Pos.get(p, p, ii) : Bln.FALSE;
                }
                case GE: {
                    return Pos.get(ex ? p : p + 1L, Long.MAX_VALUE, ii);
                }
                case GT: {
                    return Pos.get(p + 1L, Long.MAX_VALUE, ii);
                }
                case LE: {
                    return Pos.get(1L, p, ii);
                }
                case LT: {
                    return Pos.get(1L, ex ? p - 1L : p, ii);
                }
            }
        }
        return o;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCtx(ctx);
        return Bln.get(ctx.pos >= this.min && ctx.pos <= this.max);
    }

    public boolean skip(QueryContext ctx) {
        return ctx.pos >= this.max;
    }

    Expr intersect(Pos pos, InputInfo ii) {
        return Pos.get(Math.max(this.min, pos.min), Math.min(this.max, pos.max), ii);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.POS;
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Pos)) {
            return false;
        }
        Pos p = (Pos)cmp;
        return this.min == p.min && this.max == p.max;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.emptyElement(this, (byte[][])new byte[][]{QueryText.MIN, Token.token(this.min), QueryText.MAX, this.max == Long.MAX_VALUE ? QueryText.INF : Token.token(this.max)});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("position() ");
        if (this.max == Long.MAX_VALUE) {
            sb.append('>');
        }
        sb.append("= " + this.min);
        if (this.max != Long.MAX_VALUE && this.min != this.max) {
            sb.append(" to " + this.max);
        }
        return sb.toString();
    }
}

