/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CFrag;
import org.basex.query.expr.Constr;
import org.basex.query.expr.Expr;
import org.basex.query.item.ANode;
import org.basex.query.item.FElem;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.Var;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class CElem
extends CFrag {
    private final Atts nsp;
    private Expr tag;
    private final boolean comp;

    public CElem(InputInfo ii, Expr t, Atts ns, boolean c, Expr ... cont) {
        super(ii, cont);
        this.tag = t;
        this.nsp = ns;
        this.comp = c;
    }

    @Override
    public CElem comp(QueryContext ctx) throws QueryException {
        int s = ctx.ns.size();
        this.addNS(ctx);
        super.comp(ctx);
        this.tag = this.checkUp(this.tag, ctx).comp(ctx);
        ctx.ns.size(s);
        return this;
    }

    private void addNS(QueryContext ctx) throws QueryException {
        int n = this.nsp.size - 1;
        while (n >= 0) {
            ctx.ns.add(new QNm(Token.concat(Token.XMLNSC, this.nsp.key[n]), this.nsp.val[n]), this.input);
            --n;
        }
    }

    private QNm checkNS(QNm name) throws QueryException {
        byte[] pre = name.pref();
        byte[] uri = name.uri().atom();
        if (Token.eq(pre, Token.XMLNS) || Token.eq(uri, QueryText.XMLNSURI) || Token.eq(pre, Token.XML) ^ Token.eq(uri, QueryText.XMLURI)) {
            Err.CEINS.thrw(this.input, pre, uri);
        }
        return name;
    }

    @Override
    public FElem item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.checkItem(this.tag, ctx);
        int s = ctx.ns.size();
        this.addNS(ctx);
        Atts nsc = new Atts();
        int i = 0;
        while (i < this.nsp.size) {
            nsc.add(this.nsp.key[i], this.nsp.val[i]);
            ++i;
        }
        QNm tname = this.checkNS(this.qname(ctx, it, false, ii));
        byte[] pref = tname.pref();
        if (!Token.eq(pref, Token.XML)) {
            byte[] uri = ctx.ns.find(pref);
            if (uri == null) {
                uri = NSGlobal.uri(pref);
            }
            if (tname.hasUri()) {
                byte[] muri = tname.uri().atom();
                if (uri == null || !Token.eq(uri, muri)) {
                    ctx.ns.add(new QNm(tname.pref(), tname.uri()), ii);
                    nsc.add(pref, muri);
                } else if (!(nsc.contains(pref) || Token.eq(pref, Token.EMPTY) && Token.eq(uri, Token.EMPTY))) {
                    nsc.add(pref, uri);
                }
            } else if (uri != null) {
                tname.uri(uri);
            }
        }
        Constr c = new Constr(ii, ctx, this.expr);
        if (c.errAtt) {
            Err.NOATTALL.thrw(this.input, new Object[0]);
        }
        if (c.duplAtt != null) {
            (this.comp ? Err.CATTDUPL : Err.ATTDUPL).thrw(this.input, new Object[]{c.duplAtt});
        }
        FElem node = new FElem(tname, c.children, c.atts, c.base, nsc, null);
        int n = 0;
        while ((long)n < c.children.size()) {
            c.children.get(n).parent(node);
            ++n;
        }
        n = 0;
        while ((long)n < c.atts.size()) {
            ANode att = c.atts.get(n);
            QNm name = att.qname();
            if (name.ns() && name.hasUri()) {
                byte[] apre = name.pref();
                byte[] auri = name.uri().atom();
                int pos = nsc.get(apre);
                if (pos == -1) {
                    nsc.add(apre, auri);
                } else {
                    Token.eq(nsc.val[pos], auri);
                }
            }
            att.parent(node);
            ++n;
        }
        ctx.ns.size(s);
        return node;
    }

    @Override
    public Expr remove(Var v) {
        this.tag = this.tag.remove(v);
        return super.remove(v);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.tag.uses(u) || super.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.tag.count(v) + super.count(v);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        this.tag.plan(ser);
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            e.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return this.info("element");
    }

    @Override
    public String toString() {
        return this.toString(String.valueOf(Token.string(NodeType.ELM.nam())) + " { " + this.tag + " }");
    }
}

