/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CFrag;
import org.basex.query.expr.Expr;
import org.basex.query.item.FAttr;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class CAttr
extends CFrag {
    private static final byte[] NS0 = Token.token("ns0:");
    private Expr atn;
    private final boolean comp;

    public CAttr(InputInfo ii, boolean c, Expr n, Expr ... v) {
        super(ii, v);
        this.atn = n;
        this.comp = c;
    }

    @Override
    public CAttr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        this.atn = this.checkUp(this.atn, ctx).comp(ctx);
        return this;
    }

    @Override
    public FAttr item(QueryContext ctx, InputInfo ii) throws QueryException {
        QNm name = this.qname(ctx, this.checkItem(this.atn, ctx), true, ii);
        byte[] pre = name.pref();
        byte[] ln = name.ln();
        if (this.comp) {
            byte[] uri = name.uri().atom();
            if (Token.eq(pre, Token.XMLNS) || Token.eq(ln, Token.XMLNS) || Token.eq(uri, QueryText.XMLNSURI) || Token.eq(pre, Token.XML) ^ Token.eq(uri, QueryText.XMLURI)) {
                Err.CAINS.thrw(this.input, ln, uri);
            }
            if (Token.eq(pre, Token.EMPTY) && !Token.eq(uri, Token.EMPTY)) {
                name.name(Token.concat(NS0, name.atom()));
            }
        }
        TokenBuilder tb = new TokenBuilder();
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            CAttr.add(tb, ctx.iter(e), ii);
            ++n2;
        }
        byte[] val = tb.finish();
        if (Token.eq(pre, Token.XML) && Token.eq(ln, QueryText.ID)) {
            val = Token.norm(val);
        }
        return new FAttr(name, val, null);
    }

    static void add(TokenBuilder tb, Iter ir, InputInfo ii) throws QueryException {
        Item it;
        boolean m = false;
        while ((it = ir.next()) != null) {
            if (m) {
                tb.add(32);
            }
            tb.add(it.atom(ii));
            m = true;
        }
    }

    @Override
    public Expr remove(Var v) {
        this.atn = this.atn.remove(v);
        return super.remove(v);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.atn.uses(u) || super.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.atn.count(v) + super.count(v);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        this.atn.plan(ser);
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            e.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return this.info("attribute");
    }

    @Override
    public String toString() {
        return this.toString(String.valueOf(Token.string(NodeType.ATT.nam())) + " { " + this.atn + " }");
    }
}

