/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.ExprInfo;
import org.basex.data.FTPos;
import org.basex.data.FTPosData;
import org.basex.query.QueryText;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public abstract class Serializer {
    private final Atts ns = new Atts().add(Token.XML, QueryText.XMLURI).add(Token.EMPTY, Token.EMPTY);
    protected final TokenList tags = new TokenList();
    protected boolean undecl;
    private final IntList nsl = new IntList();
    protected boolean inTag;

    public abstract void openResult() throws IOException;

    public abstract void closeResult() throws IOException;

    public abstract void attribute(byte[] var1, byte[] var2) throws IOException;

    public abstract void text(byte[] var1) throws IOException;

    public abstract void text(byte[] var1, FTPos var2) throws IOException;

    public abstract void comment(byte[] var1) throws IOException;

    public abstract void pi(byte[] var1, byte[] var2) throws IOException;

    public abstract void item(byte[] var1) throws IOException;

    protected abstract void start(byte[] var1) throws IOException;

    protected abstract void empty() throws IOException;

    protected abstract void finish() throws IOException;

    protected abstract void close(byte[] var1) throws IOException;

    protected void openDoc(byte[] name) throws IOException {
    }

    protected void closeDoc() throws IOException {
    }

    protected abstract void cls() throws IOException;

    public final void openElement(ExprInfo expr, byte[] ... a) throws IOException {
        this.finishElement();
        this.openElement(this.name(expr), a);
    }

    public final void openElement(byte[] t, byte[] ... a) throws IOException {
        this.finishElement();
        this.tags.push(t);
        this.nsl.push(this.ns.size);
        this.inTag = true;
        this.start(t);
        int i = 0;
        while (i < a.length) {
            this.attribute(a[i], a[i + 1]);
            i += 2;
        }
    }

    public final void namespace(byte[] n, byte[] v) throws IOException {
        if (!this.undecl && n.length != 0 && v.length == 0) {
            return;
        }
        byte[] uri = this.ns(n);
        if (uri == null || !Token.eq(uri, v)) {
            this.attribute(n.length == 0 ? Token.XMLNS : Token.concat(Token.XMLNSC, n), v);
            this.ns.add(n, v);
        }
    }

    public final void emptyElement(byte[] t, byte[] ... a) throws IOException {
        this.openElement(t, (byte[][])new byte[0][]);
        int i = 0;
        while (i < a.length) {
            this.attribute(a[i], a[i + 1]);
            i += 2;
        }
        this.closeElement();
    }

    public final void emptyElement(ExprInfo expr, byte[] ... a) throws IOException {
        this.finishElement();
        this.emptyElement(this.name(expr), a);
    }

    public final void closeElement() throws IOException {
        if (this.tags.size() == 0) {
            throw new IOException("All elements closed.");
        }
        byte[] open = this.tags.pop();
        this.ns.size = this.nsl.pop();
        if (this.inTag) {
            this.inTag = false;
            this.empty();
        } else {
            this.close(open);
        }
    }

    public final void close() throws IOException {
        this.cls();
        if (this.tags.size() > 0) {
            throw new IOException("<" + Token.string(this.tags.peek()) + "> still opened");
        }
    }

    public boolean finished() {
        return false;
    }

    public final int level() {
        return this.tags.size();
    }

    public final byte[] ns(byte[] pre) {
        int i = this.ns.size - 1;
        while (i >= 0) {
            if (Token.eq(this.ns.key[i], pre)) {
                return this.ns.val[i];
            }
            --i;
        }
        return null;
    }

    public final int node(Data data, int pre) throws IOException {
        return this.node(data, pre, null);
    }

    public final int node(Data data, int pre, FTPosData ft) throws IOException {
        boolean doc = false;
        TokenList nsp = data.ns.size() != 0 ? new TokenList() : null;
        IntList pars = new IntList();
        TokenList names = new TokenList();
        names.set(0, this.ns(Token.EMPTY));
        int l = 0;
        int p = pre;
        int s = pre + data.size(pre, data.kind(p));
        while (p < s && !this.finished()) {
            int k = data.kind(p);
            int r = data.parent(p, k);
            while (l > 0 && pars.get(l - 1) >= r) {
                this.closeElement();
                --l;
            }
            if (k == 0) {
                if (doc) {
                    this.closeDoc();
                }
                this.openDoc(data.text(p++, true));
                doc = true;
                continue;
            }
            if (k == 2) {
                FTPos ftd;
                FTPos fTPos = ftd = ft != null ? ft.get(data, p) : null;
                if (ftd != null) {
                    this.text(data.text(p++, true), ftd);
                    continue;
                }
                this.text(data.text(p++, true));
                continue;
            }
            if (k == 4) {
                this.comment(data.text(p++, true));
                continue;
            }
            if (k == 3) {
                this.attribute(data.name(p, k), data.text(p++, false));
                continue;
            }
            if (k == 5) {
                this.pi(data.name(p, k), data.atom(p++));
                continue;
            }
            byte[] name = data.name(p, k);
            this.openElement(name, (byte[][])new byte[0][]);
            byte[] empty = names.get(l);
            if (nsp != null) {
                nsp.reset();
                int pp = p;
                do {
                    Atts atn = data.ns(pp);
                    int n = 0;
                    while (n < atn.size) {
                        byte[] key = atn.key[n];
                        byte[] val = atn.val[n];
                        if (!nsp.contains(key)) {
                            nsp.add(key);
                            this.namespace(key, val);
                            if (key.length == 0) {
                                empty = val;
                            }
                        }
                        ++n;
                    }
                } while ((pp = data.parent(pp, data.kind(pp))) >= 0 && data.kind(pp) == 1 && l == 0 && this.level() == 1);
                byte[] key = Token.pref(name);
                byte[] val = data.ns.uri(data.uri(p, k));
                if (val == null) {
                    val = Token.EMPTY;
                }
                if (key.length != 0) {
                    if (this.ns.get(key) == -1) {
                        this.namespace(key, val);
                    }
                } else if (!Token.eq(val, empty)) {
                    this.namespace(key, val);
                    empty = val;
                }
            } else if (l == 0 && this.ns(Token.EMPTY) != Token.EMPTY) {
                this.namespace(Token.EMPTY, Token.EMPTY);
            }
            int as = p + data.attSize(p, k);
            while (++p != as) {
                this.attribute(data.name(p, 3), data.text(p, false));
            }
            pars.set(l++, r);
            names.set(l, empty);
        }
        while (--l >= 0) {
            this.closeElement();
        }
        if (doc) {
            this.closeDoc();
        }
        return s;
    }

    protected byte[] name(ExprInfo expr) {
        return Token.token(expr.name());
    }

    protected final void finishElement() throws IOException {
        if (!this.inTag) {
            return;
        }
        this.inTag = false;
        this.finish();
    }
}

