/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import org.basex.util.Token;
import org.basex.util.list.IntArrayList;
import org.basex.util.list.TokenList;

final class FTTrieArray {
    final TokenList tokens;
    final IntArrayList next;

    FTTrieArray(int is) {
        this.next = new IntArrayList(is);
        this.tokens = new TokenList(is);
        int[] nArray = new int[3];
        nArray[0] = -1;
        this.next.add(nArray);
    }

    void insertSorted(byte[] v, int s, long off) {
        int[] nArray;
        if (off <= Integer.MAX_VALUE) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = (int)off;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = (int)(off >> 16 & 0xFFFFFFL);
            nArray = nArray3;
            nArray3[1] = -((int)(off & 0xFFFFL));
        }
        int[] a = nArray;
        this.insertNode(0, v, s, a);
    }

    private int insertNode(int cn, int ti, int ip) {
        int[] cnn = this.next.get(cn);
        int[] tmp = new int[cnn.length + 1];
        System.arraycopy(cnn, 0, tmp, 0, ip);
        tmp[ip] = ti;
        System.arraycopy(cnn, ip, tmp, ip + 1, tmp.length - ip - 1);
        this.next.set(cn, tmp);
        return ip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int insertNode(int cn, byte[] v, int s, int[] off) {
        int[] cnn = this.next.get(cn);
        if (cn == 0 && cnn.length > 3) {
            int p = this.pointer(cn);
            if (Token.diff(this.tokens.get(this.next.get(cnn[p])[0])[0], v[0]) == 0) return this.insertNode(cnn[p], v, s, off);
            int[] e = new int[2 + off.length];
            e[0] = this.tokens.size();
            this.tokens.add(v);
            e[1] = s;
            System.arraycopy(off, 0, e, 2, off.length);
            this.next.add(e);
            this.insertNode(cn, this.next.size() - 1, p + 1);
            return this.next.size() - 1;
        }
        byte[] is = cnn[0] == -1 ? null : this.intersection(this.tokens.get(cnn[0]), v);
        byte[] r1 = cnn[0] == -1 ? null : this.tokens.get(this.next.get(cn)[0]);
        byte[] r2 = v;
        if (is != null) {
            r1 = this.bytes(r1, is.length, r1.length);
            r2 = this.bytes(v, is.length, v.length);
        }
        if (is != null) {
            if (r1 == null) {
                if (r2 == null) return -1;
                int p = this.pointer(cn);
                if (p != 0 && Token.diff(this.tokens.get(this.next.get(cnn[p])[0])[0], r2[0]) == 0) return this.insertNode(cnn[p], r2, s, off);
                int[] e = new int[2 + off.length];
                e[0] = this.tokens.size();
                this.tokens.add(r2);
                e[1] = s;
                System.arraycopy(off, 0, e, 2, off.length);
                this.next.add(e);
                this.insertNode(cn, this.next.size() - 1, p + 1);
                return this.next.size() - 1;
            }
            if (r2 == null) {
                int[] oe = new int[3 + off.length];
                this.tokens.set(cnn[0], is);
                oe[0] = cnn[0];
                System.arraycopy(off, 0, oe, 3, off.length);
                oe[2] = s;
                cnn[0] = this.tokens.size();
                this.tokens.add(r1);
                this.next.add(cnn);
                oe[1] = this.next.size() - 1;
                this.next.set(cn, oe);
                return this.next.size() - 1;
            }
            this.tokens.set(cnn[0], is);
            int[] ne = new int[5];
            ne[0] = cnn[0];
            if (Token.diff(r2[0], r1[0]) < 0) {
                ne[1] = this.next.size();
                ne[2] = this.next.size() + 1;
            } else {
                ne[1] = this.next.size() + 1;
                ne[2] = this.next.size();
            }
            ne[3] = 0;
            ne[4] = 0;
            this.next.set(cn, ne);
            ne = new int[2 + off.length];
            ne[0] = this.tokens.size();
            this.tokens.add(r2);
            ne[1] = s;
            System.arraycopy(off, 0, ne, 2, off.length);
            this.next.add(ne);
            ne = new int[cnn.length];
            System.arraycopy(cnn, 0, ne, 0, ne.length);
            ne[0] = this.tokens.size();
            this.tokens.add(r1);
            this.next.add(ne);
            return this.next.size() - 1;
        }
        int[] ne = new int[2 + off.length];
        ne[0] = this.tokens.size();
        this.tokens.add(v);
        System.arraycopy(off, 0, ne, 2, off.length);
        ne[1] = s;
        this.next.add(ne);
        int p = cnn.length - 2;
        this.insertNode(cn, this.next.size() - 1, p);
        return this.next.size() - 1;
    }

    private byte[] intersection(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return null;
        }
        int ml = Math.min(b1.length, b2.length);
        int i = -1;
        while (++i < ml && Token.diff(b1[i], b2[i]) == 0) {
        }
        return this.bytes(b1, 0, i);
    }

    private byte[] bytes(byte[] d, int s, int e) {
        if (d == null || d.length < e || s < 0 || s == e) {
            return null;
        }
        byte[] tmp = new byte[e - s];
        System.arraycopy(d, s, tmp, 0, tmp.length);
        return tmp;
    }

    private int pointer(int cn) {
        int[] nl = this.next.get(cn);
        return nl[nl.length - 1] >= 0 ? nl.length - 3 : nl.length - 4;
    }
}

