/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.FTMatches;
import org.basex.index.Index;
import org.basex.index.IndexCache;
import org.basex.index.ft.FTFuzzy;
import org.basex.index.ft.FTIndexIterator;
import org.basex.index.ft.FTTrie;
import org.basex.io.random.DataAccess;
import org.basex.util.list.IntList;

public abstract class FTIndex
implements Index {
    final IndexCache cache = new IndexCache();
    final Data data;
    final int scm;
    final double max;
    final double min;

    public static FTIndex get(Data d, boolean wild) throws IOException {
        return wild ? new FTTrie(d) : new FTFuzzy(d);
    }

    FTIndex(Data d) {
        this.data = d;
        this.scm = d.meta.scoring;
        this.max = Math.log(this.data.meta.maxscore + 1);
        this.min = Math.log(this.data.meta.minscore - 1);
    }

    final synchronized FTIndexIterator iter(long p, final int s, DataAccess da, final boolean fast) {
        da.cursor(p);
        final IntList vals = new IntList();
        int c = 0;
        int lp = 0;
        block0: while (c < s) {
            if (lp == 0) {
                if (this.scm > 0) {
                    vals.add(da.readNum());
                }
                lp = da.readNum();
                vals.add(lp);
            }
            int pr = lp;
            vals.add(da.readNum());
            while (++c < s) {
                lp = da.readNum();
                vals.add(lp);
                if (lp != pr) continue block0;
                vals.add(da.readNum());
            }
        }
        return new FTIndexIterator(){
            final FTMatches all;
            int c;
            int pre;
            int lpre;
            double sc;
            {
                this.all = new FTMatches(this.toknum);
                this.sc = -1.0;
            }

            @Override
            public synchronized boolean more() {
                if (this.c == vals.size()) {
                    return false;
                }
                if (this.lpre == 0) {
                    if (FTIndex.this.scm > 0) {
                        this.sc = (Math.log(vals.get(this.c++)) - FTIndex.this.min) / (FTIndex.this.max - FTIndex.this.min);
                    }
                    this.lpre = vals.get(this.c++);
                    this.size = s;
                }
                this.pre = this.lpre;
                this.all.reset(this.toknum);
                this.all.or(vals.get(this.c++));
                while (this.c < vals.size() && (this.lpre = vals.get(this.c++)) == this.pre) {
                    int n = vals.get(this.c++);
                    if (fast) continue;
                    this.all.or(n);
                }
                return true;
            }

            @Override
            public synchronized FTMatches matches() {
                return this.all;
            }

            @Override
            public synchronized int next() {
                return this.pre;
            }

            @Override
            public synchronized int indexSize() {
                return s;
            }

            @Override
            public synchronized double score() {
                return this.sc;
            }

            public String toString() {
                return Integer.toString(s);
            }
        };
    }
}

