/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import org.basex.index.IntListExt;

public class IdPreMap {
    private final int baseid;
    private final IntListExt pres;
    private final IntListExt ids;
    private final IntListExt incs;
    private final IntListExt oids;

    public IdPreMap(int id) {
        this.baseid = id;
        this.pres = new IntListExt(5);
        this.ids = new IntListExt(5);
        this.incs = new IntListExt(5);
        this.oids = new IntListExt(5);
    }

    public int pre(int id) {
        if (id < this.pres.get(0) || this.pres.size() == 0) {
            return id;
        }
        if (id > this.baseid) {
            return this.pres.get(this.ids.indexOf(id));
        }
        int i = this.oids.sortedLastIndexOf(id);
        return id + this.incs.get(i < 0 ? -i - 2 : i);
    }

    public void insert(int pre, int id, int c) {
        int i = 0;
        int inc = c;
        int oid = pre;
        if (this.pres.size() > 0) {
            i = this.pres.sortedIndexOf(pre);
            if (i < 0) {
                if ((i = -i - 1) != 0) {
                    oid = pre - this.incs.get(i - 1);
                    inc += this.incs.get(i - 1);
                }
            } else if (i > 0) {
                oid = this.oids.get(i);
                inc += this.incs.get(i - 1);
            }
            this.pres.add(pre, i);
            this.incs.add(inc, i);
            this.ids.add(id, i);
            this.oids.add(oid, i);
            int k = this.pres.size() - 1;
            while (k > i) {
                this.pres.inc(k, c);
                this.incs.inc(k, c);
                --k;
            }
        } else {
            this.pres.set(i, pre);
            this.incs.set(i, inc);
            this.ids.set(i, id);
            this.oids.set(i, oid);
        }
    }

    public void delete(int pre, int id, int c) {
        int i = 0;
        int inc = c;
        int oid = pre;
        if (this.pres.size() > 0) {
            i = this.pres.sortedIndexOf(pre);
            if (i < 0) {
                if ((i = -i - 1) < this.pres.size() && this.pres.get(i) + c == pre) {
                    this.pres.inc(i, c);
                    this.incs.inc(i, c);
                } else {
                    if (i != 0) {
                        oid = pre - this.incs.get(i - 1);
                        inc += this.incs.get(i - 1);
                    }
                    this.pres.add(pre, i);
                    this.incs.add(inc, i);
                    this.ids.add(id, i);
                    this.oids.add(oid, i);
                }
            } else {
                if (i + 1 < this.pres.size() && this.pres.get(i + 1) + c == pre) {
                    this.pres.remove(i);
                    this.incs.remove(i);
                    this.ids.remove(i);
                    this.oids.remove(i);
                    this.pres.inc(i, c);
                }
                this.incs.inc(i, c);
            }
            int k = this.pres.size() - 1;
            while (k > i) {
                this.pres.inc(k, c);
                this.incs.inc(k, c);
                --k;
            }
        } else {
            this.pres.set(i, pre);
            this.incs.set(i, inc);
            this.ids.set(i, id);
            this.oids.set(i, oid);
        }
    }

    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append("pres, ids, incs, oids");
        int i = 0;
        while (i < this.pres.size()) {
            b.append('\n');
            b.append(this.pres.get(i));
            b.append(", ");
            b.append(this.ids.get(i));
            b.append(", ");
            b.append(this.incs.get(i));
            b.append(", ");
            b.append(this.oids.get(i));
            ++i;
        }
        return b.toString();
    }
}

