/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class DocIndex
implements Index {
    private final Data data;
    private IntList docs;
    private byte[][] paths;
    private int[] order;

    public DocIndex(Data d) {
        this.data = d;
    }

    public boolean read(DataInput in) throws IOException {
        this.docs = in.readDiffs();
        return true;
    }

    public void write(DataOutput out) throws IOException {
        out.writeDiffs(this.doc());
    }

    public synchronized IntList doc() {
        if (this.docs == null) {
            this.update();
            this.docs = new IntList();
            int is = this.data.meta.size;
            int i = 0;
            while (i < is) {
                this.docs.add(i);
                i += this.data.size(i, 0);
            }
            this.data.meta.dirty = true;
        }
        return this.docs;
    }

    @Override
    public IndexIterator ids(IndexToken token) {
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public int nrIDs(IndexToken token) {
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public void close() {
    }

    @Override
    public byte[] info() {
        return Token.EMPTY;
    }

    public void insert(int pre, Data d) {
        int dsize = d.meta.size;
        IntList pres = new IntList();
        int dpre = 0;
        while (dpre < dsize) {
            int k = d.kind(dpre);
            if (k == 0) {
                pres.add(pre + dpre);
            }
            dpre += d.size(dpre, k);
        }
        IntList doc = this.doc();
        int i = doc.sortedIndexOf(pre);
        if (i < 0) {
            i = -i - 1;
        }
        doc.insert(i, pres.toArray());
        doc.move(dsize, i + pres.size());
        this.update();
    }

    public void delete(int pre, int size) {
        IntList doc = this.doc();
        int i = doc.sortedIndexOf(pre);
        if (i < 0) {
            i = -i - 1;
        } else {
            doc.delete(i);
        }
        doc.move(-size, i);
        this.update();
    }

    public void replace(int pre, Data d) {
        this.delete(pre, d.meta.size);
        this.insert(pre, d);
    }

    public void update() {
        this.paths = null;
        this.order = null;
    }

    public synchronized IntList doc(String path) {
        if (this.data.empty()) {
            return new IntList(0);
        }
        IntList doc = this.doc();
        if (path.isEmpty()) {
            return doc;
        }
        int ds = doc.size();
        if (this.paths == null) {
            this.paths = new byte[ds][];
            int d = 0;
            while (d < ds) {
                byte[] txt = this.data.text(doc.get(d), true);
                this.paths[d] = Token.concat(Token.SLASH, Prop.WIN ? Token.lc(txt) : txt);
                ++d;
            }
            this.order = Array.createOrder(this.paths, false, true);
        }
        String np = path.replaceAll("[\\\\//]+", "/").replaceAll("^/|/$", "");
        byte[] exact = Token.concat(Token.SLASH, Prop.WIN ? Token.lc(Token.token(np)) : Token.token(np));
        byte[] start = Token.endsWith(exact, Token.SLASH) ? exact : Token.concat(exact, Token.SLASH);
        IntList il = new IntList();
        int p = this.find(exact);
        while (p < this.paths.length) {
            if (Token.eq(this.paths[p], exact) || Token.startsWith(this.paths[p], start)) {
                il.add(doc.get(this.order[p]));
            }
            ++p;
        }
        return il.sort();
    }

    private int find(byte[] v) {
        int l = 0;
        int h = this.order.length - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int c = Token.diff(this.paths[m], v);
            if (c == 0) {
                while (m > 0 && Token.eq(this.paths[m - 1], v)) {
                    --m;
                }
                return m;
            }
            if (c < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return l;
    }
}

