/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import org.basex.core.Context;
import org.basex.core.cmd.Find;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.data.StatsKey;
import org.basex.gui.GUIProp;
import org.basex.gui.view.table.TableIterator;
import org.basex.index.Names;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class TableData {
    private static final int MAXROWS = 1000;
    private static final byte[] MAXTOK = new byte[]{-1};
    private static final byte[] MAXNUM = Token.token(Double.MAX_VALUE);
    final Context context;
    TokenList roots;
    IntList rootRows;
    IntList rows;
    TableCol[] cols;
    int rowH;
    int sortCol = -1;
    boolean asc;
    int mouseX;
    int mouseY;
    int root;
    private final GUIProp gprop;
    private String last = "";

    TableData(Context ctx, GUIProp pr) {
        this.context = ctx;
        this.gprop = pr;
    }

    void init(Data data) {
        this.roots = new TokenList();
        for (byte[] k : data.pthindex.desc(Token.EMPTY, data, true, true)) {
            int c = 0;
            for (byte[] kk : data.pthindex.desc(k, data, true, false)) {
                Names nm;
                Names names = nm = Token.startsWith(kk, 64) ? data.atnindex : data.tagindex;
                if (!nm.stat((int)nm.id((byte[])Token.delete((byte[])kk, (int)64))).leaf) continue;
                ++c;
            }
            if (c <= 2) continue;
            this.roots.add(k);
        }
        this.init(data, -1);
    }

    void init(Data data, int r) {
        this.cols = new TableCol[0];
        this.root = r;
        this.sortCol = -1;
        this.last = "";
        this.rowH = 1;
        if (r == -1 && this.roots.size() == 0) {
            return;
        }
        if (this.root == -1) {
            this.root = data.tagindex.id(this.roots.get(0));
        }
        for (byte[] k : data.pthindex.desc(data.tagindex.key(this.root), data, true, true)) {
            Names index;
            boolean elem = !Token.startsWith(k, 64);
            byte[] key = Token.delete(k, 64);
            Names names = index = elem ? data.tagindex : data.atnindex;
            if (!index.stat((int)index.id((byte[])key)).leaf) continue;
            this.addCol(key, elem);
        }
        this.context(true);
    }

    void context(boolean create) {
        if (this.cols.length == 0) {
            return;
        }
        Nodes n = this.context.current;
        if (!create && n.root && this.rootRows != null) {
            this.rows = this.rootRows;
            this.sortCol = -1;
        } else {
            this.createRows();
            if (n.root) {
                this.rootRows = this.rows;
            }
        }
        if (this.cols[0].width == 0.0 && this.cols[0].hwidth == 0.0) {
            this.calcWidths();
        }
    }

    private void addCol(byte[] name, boolean elem) {
        Data data = this.context.data;
        int id = (elem ? data.tagindex : data.atnindex).id(name);
        if (id == 0) {
            return;
        }
        TableCol col = new TableCol();
        col.id = id;
        col.elem = elem;
        col.name = name;
        this.cols = Array.add(this.cols, col);
    }

    private void createRows() {
        Data data = this.context.data;
        int[] n = this.context.current.list;
        this.rows = new IntList();
        int[] nArray = n;
        int n2 = n.length;
        int n3 = 0;
        while (n3 < n2) {
            int p = nArray[n3];
            int s = p + data.size(p, data.kind(p));
            while ((data.kind(p) != 1 || data.name(p) != this.root) && ++p < s) {
            }
            while (p < s) {
                int k = data.kind(p);
                if (k == 1 && data.name(p) == this.root) {
                    this.rows.add(p);
                }
                p += data.attSize(p, k);
            }
            ++n3;
        }
        this.sort();
    }

    private void calcWidths() {
        if (this.cols.length == 0) {
            return;
        }
        Data data = this.context.data;
        int cs = this.cols.length;
        int nRows = this.rows.size();
        TableIterator ti = new TableIterator(data, this);
        int ll = Math.min(nRows, 1000);
        int l = 0;
        while (l < ll) {
            ti.init(this.rows.get(l));
            while (ti.more()) {
                this.cols[ti.col].width += (double)data.textLen(ti.pre, ti.text);
            }
            ++l;
        }
        double[] widths = new double[cs];
        int c = 0;
        while (c < cs) {
            widths[c] = this.cols[c].width;
            ++c;
        }
        int[] il = Array.createOrder(widths, false);
        TableCol[] cl = new TableCol[cs];
        int c2 = 0;
        while (c2 < cs) {
            cl[c2] = this.cols[il[c2]];
            ++c2;
        }
        this.cols = cl;
        this.setWidths(false);
    }

    void setWidths(boolean force) {
        double sum = 0.0;
        int cs = this.cols.length;
        int c = 0;
        while (c < cs) {
            sum += this.cols[c].width;
            ++c;
        }
        double min = force ? 0.0 : 0.5;
        int c2 = 0;
        while (c2 < cs) {
            this.cols[c2].width = Math.max(min / (double)cs, this.cols[c2].width / sum);
            ++c2;
        }
        sum = 0.0;
        c2 = 0;
        while (c2 < cs) {
            sum += this.cols[c2].width;
            ++c2;
        }
        c2 = 0;
        while (c2 < cs) {
            this.cols[c2].width /= sum;
            ++c2;
        }
    }

    void sort() {
        if (this.sortCol == -1) {
            return;
        }
        int c = this.cols[this.sortCol].id;
        boolean e = this.cols[this.sortCol].elem;
        Data data = this.context.data;
        Names index = e ? data.tagindex : data.atnindex;
        StatsKey.Kind kind = index.stat((int)c).kind;
        boolean num = kind == StatsKey.Kind.INT || kind == StatsKey.Kind.DBL;
        byte[][] tokens = new byte[this.rows.size()][];
        int rs = this.rows.size();
        int r = 0;
        while (r < rs) {
            int p = this.rows.get(r);
            int s = p + data.size(p, data.kind(p));
            while (p != s) {
                int k = data.kind(p);
                if ((e && k == 1 || !e && k == 3) && data.name(p) == c) {
                    tokens[r] = data.atom(p);
                    break;
                }
                p += e ? data.attSize(p, k) : 1;
            }
            if (tokens[r] == null || tokens[r].length == 0) {
                tokens[r] = num ? MAXNUM : MAXTOK;
            }
            ++r;
        }
        this.rows.sort(tokens, num, this.asc);
    }

    int getRoot(Data data, int pre) {
        if (pre == -1) {
            return -1;
        }
        int p = pre;
        int k = data.kind(p);
        while (p != -1 && (k != 1 || data.name(p) != this.root)) {
            int n = k = (p = data.parent(p, k)) != -1 ? data.kind(p) : 0;
        }
        return p;
    }

    int column(int w, int mx) {
        double cs = 0.0;
        int i = 0;
        while (i < this.cols.length) {
            double cw = (double)w * this.cols[i].width;
            double ce = cs + cw;
            if ((double)mx > cs && (double)mx < ce) {
                return i;
            }
            cs = ce;
            ++i;
        }
        return -1;
    }

    void resetFilter() {
        int f = 0;
        while (f < this.cols.length) {
            this.cols[f].filter = "";
            ++f;
        }
    }

    String find() {
        Data data = this.context.data;
        boolean r = this.rows == this.rootRows;
        StringList filters = new StringList();
        TokenList names = new TokenList();
        BoolList elems = new BoolList();
        TableCol[] tableColArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            TableCol col = tableColArray[n2];
            filters.add(col.filter);
            names.add(col.name);
            elems.add(col.elem);
            ++n2;
        }
        String query = Find.findTable(filters, names, elems, data.tagindex.key(this.root), this.gprop.is(GUIProp.FILTERRT) || r);
        if (query.equals(this.last)) {
            return null;
        }
        this.last = query;
        return query;
    }

    int rowH(double f) {
        this.rowH = Math.max(1, (int)(f * (double)this.gprop.num(GUIProp.FONTSIZE) * 7.0 / 4.0));
        return this.rowH;
    }

    static final class TableCol {
        byte[] name;
        int id;
        boolean elem;
        double width;
        double hwidth;
        String filter = "";

        TableCol() {
        }
    }
}

