/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;

public class BaseXTextField
extends JTextField {
    public static final int DWIDTH = 280;
    String last = "";
    BaseXEditor area;
    byte[] help;

    public BaseXTextField(Window win) {
        this(null, win);
    }

    public BaseXTextField(String txt, Window win) {
        BaseXLayout.setWidth(this, 280);
        BaseXLayout.addInteraction(this, win);
        if (txt != null) {
            this.setText(txt);
            this.selectAll();
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (BaseXTextField.this.area != null) {
                    BaseXTextField.this.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseXLayout.focus(e.getComponent(), BaseXTextField.this.help);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.UNDO.is(e) || BaseXKeys.REDO.is(e)) {
                    String t = BaseXTextField.this.getText();
                    BaseXTextField.this.setText(BaseXTextField.this.last);
                    BaseXTextField.this.last = t;
                }
                if (BaseXTextField.this.area == null) {
                    return;
                }
                String text = BaseXTextField.this.getText();
                boolean enter = BaseXKeys.ENTER.is(e);
                if (BaseXKeys.ESCAPE.is(e) || enter && text.isEmpty()) {
                    BaseXTextField.this.area.requestFocusInWindow();
                } else if (enter || BaseXKeys.FINDNEXT.is(e) || BaseXKeys.FINDPREV.is(e) || BaseXKeys.FINDNEXT2.is(e) || BaseXKeys.FINDPREV2.is(e)) {
                    BaseXTextField.this.area.find(text, BaseXKeys.FINDPREV.is(e) || BaseXKeys.FINDPREV2.is(e) || e.isShiftDown());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BaseXTextField.this.area == null) {
                    return;
                }
                String text = BaseXTextField.this.getText();
                char ch = e.getKeyChar();
                if (!BaseXKeys.control(e) && Character.isDefined(ch) && !BaseXKeys.ENTER.is(e)) {
                    BaseXTextField.this.area.find(text, false);
                }
                BaseXTextField.this.repaint();
            }
        });
        this.setDragEnabled(true);
        BaseXLayout.addDrop(this, new BaseXLayout.DropHandler(){

            @Override
            public void drop(Object object) {
                BaseXTextField.this.replaceSelection(object.toString());
            }
        });
    }

    public final void setSearch(BaseXEditor a) {
        this.area = a;
        BaseXLayout.setWidth(this, 120);
    }

    @Override
    public void setText(String txt) {
        this.last = txt;
        super.setText(txt);
    }

    public final void help(byte[] hlp) {
        this.help = hlp;
    }
}

