/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXLayout;
import org.basex.util.Table;
import org.basex.util.Token;

public final class BaseXTable
extends JTable {
    public Table data;
    final Dialog dialog;
    private final TableModel model;

    public BaseXTable(Table t, Dialog d) {
        this.data = t;
        this.dialog = d;
        this.model = new TableModel();
        this.setDefaultRenderer(Boolean.class, new CellRenderer());
        this.setModel(this.model);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        BaseXLayout.addInteraction(this, d);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && BaseXTable.this.getSelectedColumn() != -1) {
                    BaseXTable.this.dialog.action(e.getSource());
                }
            }
        });
    }

    public void update(Table t) {
        this.data = t;
        this.model.fireTableChanged(null);
        int i = 1;
        while (i < this.data.cols()) {
            TableColumn tc = this.getColumnModel().getColumn(i);
            tc.setResizable(false);
            tc.setPreferredWidth(30);
            ++i;
        }
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable tab, Object val, boolean sel, boolean foc, int row, int col) {
            if (val instanceof Boolean) {
                JCheckBox box = new JCheckBox();
                box.setHorizontalAlignment(0);
                box.setSelected((Boolean)val);
                box.setEnabled(BaseXTable.this.isCellEditable(row, col));
                box.setOpaque(false);
                return box;
            }
            return super.getTableCellRendererComponent(tab, val, sel, foc, row, col);
        }
    }

    final class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        @Override
        public int getColumnCount() {
            return BaseXTable.this.data.cols();
        }

        @Override
        public int getRowCount() {
            return BaseXTable.this.data.rows();
        }

        @Override
        public String getColumnName(int col) {
            return Token.string(BaseXTable.this.data.header.get(col));
        }

        @Override
        public Object getValueAt(int row, int col) {
            String o = BaseXTable.this.data.value(row, col);
            return o.isEmpty() ? Boolean.FALSE : (o.equals("X") ? Boolean.TRUE : o);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 && !BaseXTable.this.data.value(row, 0).equals("admin");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            BaseXTable.this.dialog.action(new Object[]{value, row, col});
        }
    }
}

