/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.ShowDatabases;
import org.basex.core.cmd.ShowSessions;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogUser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPassword;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.server.ClientSession;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogServer
extends Dialog {
    public final BaseXPassword logpass;
    final BaseXTabs tabs;
    final DialogUser user = new DialogUser(true, this);
    final DialogUser dbsP = new DialogUser(false, this);
    final BaseXBack databases = this.dbsP.getTablePanel();
    final BaseXBack sess = new BaseXBack();
    final BaseXBack logs = new BaseXBack();
    final BaseXTextField loguser;
    final BaseXButton disconnect;
    final BaseXButton refreshSess;
    int tab;
    private final Context ctx;
    private final BaseXButton refreshLog;
    private final BaseXBack conn;
    private final BaseXButton stop;
    private final BaseXButton start;
    private final BaseXButton connect;
    private final BaseXButton delete;
    private final BaseXButton deleteAll;
    private final BaseXTextField host;
    private final BaseXTextField ports;
    private final BaseXTextField portc;
    private final BaseXEditor sese;
    private final BaseXEditor sedb;
    private final BaseXEditor logt;
    private final BaseXLabel infoC;
    private final BaseXLabel infoL;
    private final BaseXCombo logc;
    private final File logdir;
    private ClientSession cs;
    private boolean running;
    private boolean connected;

    public DialogServer(GUI main) {
        super(main, Text.GUISERVER);
        this.ctx = this.gui.context;
        this.conn = new BaseXBack();
        this.logdir = this.ctx.mprop.dbpath(".logs");
        this.databases.border(8);
        this.tabs = new BaseXTabs(this);
        this.tabs.add(Text.CONNECT, this.conn);
        this.tabs.add(Text.USERS, this.user);
        this.tabs.add(Text.DATABASES, this.databases);
        this.tabs.add(Text.SESSIONS, this.sess);
        this.tabs.add(Text.LOCALLOGS, this.logs);
        this.conn.border(8).layout(new BorderLayout(0, 32));
        this.start = new BaseXButton(Text.BUTTONSTART, this);
        this.stop = new BaseXButton(Text.BUTTONSTOP, this);
        this.connect = new BaseXButton(Text.BUTTONCONNECT, this);
        this.disconnect = new BaseXButton(Text.BUTTONDISCONNECT, this);
        BaseXButton.setMnemonics(this.start, this.stop, this.connect, this.disconnect);
        this.host = new BaseXTextField(this.ctx.mprop.get(MainProp.HOST), this);
        this.host.addKeyListener(this.keys);
        this.ports = new BaseXTextField(Integer.toString(this.ctx.mprop.num(MainProp.SERVERPORT)), this);
        this.ports.addKeyListener(this.keys);
        this.portc = new BaseXTextField(Integer.toString(this.ctx.mprop.num(MainProp.PORT)), this);
        this.portc.addKeyListener(this.keys);
        this.loguser = new BaseXTextField(this.gui.gprop.get(GUIProp.SERVERUSER), this);
        this.loguser.addKeyListener(this.keys);
        this.logpass = new BaseXPassword(main);
        this.logpass.addKeyListener(this.keys);
        this.infoC = new BaseXLabel(" ").border(8, 0, 0, 0);
        BaseXBack p = new BaseXBack(new TableLayout(6, 1, 0, 0));
        p.add(new BaseXLabel(String.valueOf(Text.LOCALSERVER) + ": ", true, true));
        BaseXBack pp = new BaseXBack(new TableLayout(2, 2, 8, 4)).border(0, 0, 0, 0);
        pp.add(new BaseXLabel(String.valueOf(Text.PORT) + ": "));
        pp.add(this.ports);
        pp.add(new BaseXLabel());
        BaseXBack ppp = new BaseXBack(new TableLayout(1, 2, 5, 0));
        ppp.add(this.start);
        ppp.add(this.stop);
        pp.add(ppp);
        p.add(pp);
        p.add(new BaseXLabel());
        p.add(new BaseXLabel(String.valueOf(Text.ADMINLOGIN) + ": ", true, true).border(8, 0, 4, 0));
        pp = new BaseXBack(new TableLayout(5, 2, 8, 4));
        pp.add(new BaseXLabel(String.valueOf(Text.SERVERUSER) + ": "));
        pp.add(this.loguser);
        pp.add(new BaseXLabel(String.valueOf(Text.SERVERPW) + ": "));
        pp.add(this.logpass);
        pp.add(new BaseXLabel(String.valueOf(Text.HOST) + ": "));
        pp.add(this.host);
        pp.add(new BaseXLabel(String.valueOf(Text.PORT) + ": "));
        pp.add(this.portc);
        pp.add(new BaseXLabel());
        ppp = new BaseXBack(new TableLayout(1, 2, 5, 0));
        ppp.add(this.connect);
        ppp.add(this.disconnect);
        pp.add(ppp);
        p.add(pp);
        p.add(this.infoC);
        this.conn.add((Component)p, "Center");
        p = new BaseXBack(new TableLayout(2, 1));
        BaseXLabel l = new BaseXLabel(Text.SERVERINFO1);
        l.setForeground(GUIConstants.COLORDARK);
        p.add(l);
        l = new BaseXLabel(Text.SERVERINFO2);
        l.setForeground(GUIConstants.COLORDARK);
        p.add(l);
        this.conn.add((Component)p, "South");
        this.sess.border(8).layout(new BorderLayout());
        this.sese = new BaseXEditor(false, (Window)this);
        this.sese.setFont(this.start.getFont());
        this.sedb = new BaseXEditor(false, (Window)this);
        this.sedb.setFont(this.start.getFont());
        this.refreshSess = new BaseXButton(Text.BUTTONREFRESH, this);
        this.refreshSess.setMnemonic();
        p = new BaseXBack(new GridLayout(2, 1, 0, 2));
        pp = new BaseXBack(new BorderLayout());
        pp.add((Component)new BaseXLabel(String.valueOf(Text.SESSIONS) + ": ", false, true), "North");
        pp.add((Component)this.sese, "Center");
        p.add(pp);
        pp = new BaseXBack(new BorderLayout());
        pp.add((Component)new BaseXLabel(String.valueOf(Text.DATABASES) + ": ", false, true), "North");
        pp.add((Component)this.sedb, "Center");
        p.add(pp);
        this.sess.add((Component)p, "Center");
        p = new BaseXBack(new BorderLayout(0, 0));
        p.add((Component)this.refreshSess, "East");
        this.sess.add((Component)p, "South");
        this.logs.border(8).layout(new BorderLayout());
        this.delete = new BaseXButton(Text.BUTTONDELETE, this);
        this.deleteAll = new BaseXButton(Text.BUTTONDELALL, this);
        BaseXButton.setMnemonics(this.delete, this.deleteAll);
        this.logc = new BaseXCombo(this, new String[0]);
        this.logt = new BaseXEditor(false, (Window)this);
        this.logt.setFont(this.start.getFont());
        BaseXLayout.setHeight(this.logt, 100);
        this.logt.border(5, 5, 5, 5);
        this.infoL = new BaseXLabel(" ").border(8, 0, 0, 0);
        this.refreshLog = new BaseXButton(Text.BUTTONREFRESH, this);
        this.refreshLog.setMnemonic();
        p = new BaseXBack(new BorderLayout());
        pp = new BaseXBack();
        pp.add(this.logc);
        pp.add(this.delete);
        pp.add(this.deleteAll);
        p.add((Component)pp, "West");
        this.logs.add((Component)p, "North");
        this.logs.add((Component)this.logt, "Center");
        p = new BaseXBack(new BorderLayout(8, 0));
        p.add((Component)this.infoL, "West");
        p.add((Component)this.refreshLog, "East");
        this.logs.add((Component)p, "South");
        this.set(this.tabs, "Center");
        this.running = this.ping(true);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BaseXTabs pane = (BaseXTabs)evt.getSource();
                DialogServer.this.tab = pane.getSelectedIndex();
                Component o = pane.getSelectedComponent();
                if (o == DialogServer.this.logs) {
                    DialogServer.this.refreshLog();
                }
                if (o == DialogServer.this.user) {
                    DialogServer.this.action(DialogServer.this.user);
                }
                if (o == DialogServer.this.databases) {
                    DialogServer.this.action(DialogServer.this.dbsP);
                }
                if (o == DialogServer.this.sess) {
                    DialogServer.this.action(DialogServer.this.refreshSess);
                }
            }
        });
        this.refreshLog();
        this.action(null);
        this.setResizable(true);
        this.finish(null);
    }

    private boolean ping(boolean local) {
        return BaseXServer.ping(local ? "localhost" : this.ctx.mprop.get(MainProp.HOST), this.ctx.mprop.num(local ? MainProp.SERVERPORT : MainProp.PORT));
    }

    @Override
    public void action(Object cmp) {
        String msg2;
        String msg;
        GUIConstants.Msg icon;
        block38: {
            icon = GUIConstants.Msg.SUCCESS;
            msg = null;
            msg2 = null;
            try {
                if (cmp == this.start || cmp == this.ports) {
                    int p = Integer.parseInt(this.ports.getText());
                    this.gui.setMain(MainProp.SERVERPORT, p);
                    if (this.host.getText().equals("localhost")) {
                        this.gui.setMain(MainProp.PORT, p);
                        this.portc.setText(this.ports.getText());
                    }
                    if ((msg = BaseXServer.start(p, BaseXServer.class, new String[0])).equals(Text.SERVERSTART)) {
                        this.running = true;
                    } else {
                        icon = GUIConstants.Msg.ERROR;
                    }
                } else if (cmp == this.stop) {
                    if (this.running) {
                        BaseXServer.stop(this.ctx.mprop.num(MainProp.SERVERPORT), this.ctx.mprop.num(MainProp.EVENTPORT));
                    }
                    this.running = this.ping(true);
                    boolean bl = this.connected = this.connected && this.ping(false);
                    if (!this.connected) {
                        msg = Text.SERVERSTOPPED;
                    }
                    if (this.host.getText().equals("localhost")) {
                        this.logpass.setText("");
                    }
                    if (!this.connected) {
                        super.setTitle(Text.GUISERVER);
                    }
                } else if (cmp == this.connect || cmp == this.loguser || cmp == this.logpass || cmp == this.host || cmp == this.portc) {
                    this.gui.gprop.set(GUIProp.SERVERUSER, this.loguser.getText());
                    String pw = new String(this.logpass.getPassword());
                    this.gui.setMain(MainProp.HOST, this.host.getText());
                    this.gui.setMain(MainProp.PORT, Integer.parseInt(this.portc.getText()));
                    this.cs = new ClientSession(this.ctx, this.gui.gprop.get(GUIProp.SERVERUSER), pw);
                    this.user.setSess(this.cs);
                    this.dbsP.setSess(this.cs);
                    this.connected = true;
                    super.setTitle(String.valueOf(Text.GUISERVER) + "- " + this.loguser.getText() + "@" + this.host.getText() + ":" + this.portc.getText());
                    msg = Util.info(Text.CONNECTED, this.host.getText(), this.portc.getText());
                    this.refreshSess();
                } else if (cmp == this.disconnect) {
                    this.cs.execute(new Exit());
                    this.connected = false;
                    this.logpass.setText("");
                    super.setTitle(Text.GUISERVER);
                    msg = Text.DISCONNECTED;
                } else if (cmp == this.refreshSess) {
                    this.refreshSess();
                } else if (cmp == this.refreshLog || cmp == this.logc) {
                    byte[] cont = Token.EMPTY;
                    if (this.logc.getSelectedIndex() != -1) {
                        File f = new File(this.logdir, this.logc.getSelectedItem().toString());
                        cont = new IOFile(f).content();
                    }
                    this.logt.setText(cont);
                    this.logt.scrollToEnd();
                } else if (cmp == this.delete) {
                    File f = new File(this.logdir, this.logc.getSelectedItem().toString());
                    if (f.delete()) {
                        this.logc.setSelectedIndex(-1);
                        this.refreshLog();
                    } else {
                        msg2 = Util.info(Text.DBNOTDELETED, f.getName());
                        icon = GUIConstants.Msg.ERROR;
                    }
                } else if (cmp == this.deleteAll) {
                    File file = null;
                    int i = 0;
                    while (i < this.logc.getItemCount()) {
                        File f = new File(this.logdir, this.logc.getItemAt(i).toString());
                        if (!f.delete()) {
                            file = f;
                        }
                        ++i;
                    }
                    if (file != null) {
                        msg2 = Util.info(Text.DBNOTDELETED, file.getName());
                        icon = GUIConstants.Msg.ERROR;
                    }
                    this.logc.setSelectedIndex(-1);
                    this.refreshLog();
                } else if (this.connected) {
                    if (this.tab == 1) {
                        this.user.action(cmp);
                    }
                    if (this.tab == 2) {
                        this.dbsP.action(cmp);
                    }
                }
            }
            catch (Exception ex) {
                icon = GUIConstants.Msg.ERROR;
                msg = Util.server(ex);
                ex.printStackTrace();
                if (!msg.equals(Util.info(Text.PERMNO, new Object[]{Commands.CmdPerm.values()[4]}))) break block38;
                try {
                    this.cs.execute(new Exit());
                }
                catch (BaseXException exx) {
                    Util.stack(exx);
                }
            }
        }
        boolean valp = this.portc.getText().matches("[\\d]+") && Integer.parseInt(this.portc.getText()) <= 65535;
        boolean valpl = this.ports.getText().matches("[\\d]+") && Integer.parseInt(this.ports.getText()) <= 65535;
        boolean vallu = this.loguser.getText().matches("[\\w]*");
        boolean vallp = new String(this.logpass.getPassword()).matches("[^ ;'\\\"]*");
        boolean valh = this.host.getText().matches("([\\w]+://)?[\\w.-]+");
        if (!(msg != null || msg2 != null || valpl && valh && valp && vallu && vallp)) {
            msg = Util.info(Text.INVALID, !valpl ? Text.LOCALPORT : (!valh ? Text.HOST : (!valp ? Text.PORT : (!vallu ? Text.SERVERUSER : Text.SERVERPW))));
            icon = GUIConstants.Msg.WARN;
        }
        this.infoC.setText(msg, icon);
        this.infoL.setText(msg2, icon);
        this.ports.setEnabled(!this.running);
        this.start.setEnabled(!this.running && valpl);
        this.stop.setEnabled(this.running);
        this.loguser.setEnabled(!this.connected);
        this.logpass.setEnabled(!this.connected);
        this.host.setEnabled(!this.connected);
        this.portc.setEnabled(!this.connected);
        this.connect.setEnabled(!this.connected && vallu && vallp && valh && valp && !this.loguser.getText().isEmpty() && this.logpass.getPassword().length != 0);
        this.disconnect.setEnabled(this.connected);
        this.tabs.setEnabledAt(1, this.connected);
        this.tabs.setEnabledAt(2, this.connected);
        this.tabs.setEnabledAt(3, this.connected);
        this.tabs.setEnabledAt(4, this.running || this.logc.getItemCount() > 0);
        this.refreshLog.setEnabled(this.logc.getSelectedIndex() != -1);
        this.delete.setEnabled(this.logc.getSelectedIndex() != -1);
        this.deleteAll.setEnabled(this.logc.getItemCount() > 0);
        if (this.loguser.hasFocus()) {
            this.logpass.setText("");
            this.connect.setEnabled(false);
        }
        this.ctx.mprop.write();
    }

    private void refreshSess() throws BaseXException {
        this.sese.setText(Token.token(this.cs.execute(new ShowSessions())));
        this.sedb.setText(Token.token(this.cs.execute(new ShowDatabases())));
    }

    void refreshLog() {
        this.logc.removeAllItems();
        String[] files = this.logdir.list();
        StringList sl = new StringList();
        if (files != null) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.endsWith(".log")) {
                    sl.add(s);
                }
                ++n2;
            }
        }
        sl.sort(false, false);
        for (String s : sl) {
            this.logc.addItem(s);
        }
        this.action(this.refreshLog);
    }

    @Override
    public void cancel() {
        try {
            if (this.connected) {
                this.cs.execute(new Exit());
            }
        }
        catch (BaseXException ex) {
            Util.debug(ex);
        }
        super.cancel();
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }
}

