/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.List;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.DialogFT;
import org.basex.gui.dialog.DialogImport;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DialogCreate
extends DialogImport {
    private final BaseXTextField dbname;
    private final BaseXCheckBox pathindex;
    private final BaseXCheckBox txtindex;
    private final BaseXCheckBox atvindex;
    private final BaseXCheckBox ftxindex;
    private final DialogFT ft;
    private final StringList db;

    public DialogCreate(GUI main) {
        super(main, Text.CREATEADVTITLE);
        this.db = List.list(main.context);
        Prop prop = this.gui.context.prop;
        GUIProp gprop = main.gprop;
        BaseXBack p1 = new BaseXBack(new BorderLayout()).border(8);
        BaseXBack p = new BaseXBack(new TableLayout(8, 2, 8, 0));
        this.init(p);
        p.add(new BaseXLabel(Text.CREATENAME, false, true).border(8, 0, 4, 0));
        p.add(new BaseXLabel());
        this.dbname = new BaseXTextField(gprop.get(GUIProp.CREATENAME), this);
        this.dbname.addKeyListener(this.keys);
        p.add(this.dbname);
        p.add(new BaseXLabel());
        p1.add((Component)p, "Center");
        this.info = new BaseXLabel(" ");
        p1.add((Component)this.info, "South");
        BaseXBack p3 = new BaseXBack(new TableLayout(6, 1, 0, 0)).border(8);
        this.pathindex = new BaseXCheckBox(Text.INFOPATHINDEX, prop.is(Prop.PATHINDEX), 0, this);
        p3.add(this.pathindex);
        p3.add(new BaseXLabel(Text.PATHINDEXINFO, true, false));
        this.txtindex = new BaseXCheckBox(Text.INFOTEXTINDEX, prop.is(Prop.TEXTINDEX), 0, this);
        p3.add(this.txtindex);
        p3.add(new BaseXLabel(Text.TXTINDEXINFO, true, false));
        this.atvindex = new BaseXCheckBox(Text.INFOATTRINDEX, prop.is(Prop.ATTRINDEX), 0, this);
        p3.add(this.atvindex);
        p3.add(new BaseXLabel(Text.ATTINDEXINFO, true, false));
        BaseXBack p4 = new BaseXBack(new TableLayout(2, 1, 0, 0)).border(8);
        this.ftxindex = new BaseXCheckBox(Text.INFOFTINDEX, prop.is(Prop.FTINDEX), 0, this);
        p4.add(this.ftxindex);
        this.ft = new DialogFT(this, true);
        p4.add(this.ft);
        BaseXTabs tabs = new BaseXTabs(this);
        tabs.addTab(Text.GENERALINFO, p1);
        tabs.addTab(Text.PARSEINFO, this.parsing);
        tabs.addTab(Text.INDEXINFO, p3);
        tabs.addTab(Text.FTINFO, p4);
        this.set(tabs, "Center");
        this.action(null);
        this.finish(null);
    }

    @Override
    protected IOFile choose() {
        IOFile input = super.choose();
        if (input != null) {
            this.dbname.setText(input.dbname().replaceAll("[^\\w-]", ""));
        }
        return input;
    }

    @Override
    public void action(Object cmp) {
        boolean valid = this.action(cmp, true);
        this.ft.action(this.ftxindex.isSelected());
        String pth = this.path.getText().trim();
        String nm = this.dbname.getText().trim();
        boolean bl = this.ok = valid && !nm.isEmpty();
        String inf = !valid ? Text.PATHWHICH : (!this.ok ? Text.DBWHICH : null);
        GUIConstants.Msg icon = GUIConstants.Msg.ERROR;
        if (this.ok) {
            this.ok = Command.validName(nm, false);
            if (!this.ok) {
                inf = Util.info(Text.INVALID, Text.EDITNAME);
            } else if (pth.isEmpty()) {
                inf = Text.EMPTYDATABASE;
                icon = GUIConstants.Msg.WARN;
            } else if (this.db.contains(nm)) {
                inf = Text.RENAMEOVER;
                icon = GUIConstants.Msg.WARN;
            }
        }
        if (this.ok) {
            this.gui.gprop.set(GUIProp.CREATENAME, nm);
        }
        this.info.setText(inf, icon);
        DialogCreate.enableOK(this.buttons, Text.BUTTONOK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        this.gui.set(Prop.PATHINDEX, this.pathindex.isSelected());
        this.gui.set(Prop.TEXTINDEX, this.txtindex.isSelected());
        this.gui.set(Prop.ATTRINDEX, this.atvindex.isSelected());
        this.gui.set(Prop.FTINDEX, this.ftxindex.isSelected());
        this.ft.close();
    }
}

