/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.File;
import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.Users;
import org.basex.core.cmd.DropDB;
import org.basex.io.IO;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.Language;

public final class MetaData {
    public final Prop prop;
    public String name;
    public Users users;
    public String encoding = "UTF-8";
    public String original = "";
    public long filesize;
    public int ndocs;
    public long time;
    public boolean chop;
    public boolean textindex;
    public boolean attrindex;
    public boolean ftindex;
    public boolean pathindex = true;
    public boolean wildcards;
    public boolean stemming;
    public boolean casesens;
    public boolean diacritics;
    public Language language;
    public int maxscore;
    public int minscore;
    public int scoring;
    public boolean uptodate = true;
    public boolean oldindex;
    public boolean dirty;
    public int size;
    public int lastid = -1;
    private final File path;

    public MetaData(Prop pr) {
        this("", pr, null);
    }

    public MetaData(String db, Context ctx) {
        this(db, ctx.prop, ctx.mprop);
    }

    public MetaData(String db, Prop pr, MainProp mprop) {
        this.path = mprop != null ? mprop.dbpath(db) : null;
        this.prop = pr;
        this.name = db;
        this.chop = this.prop.is(Prop.CHOP);
        this.pathindex = this.prop.is(Prop.PATHINDEX);
        this.wildcards = this.prop.is(Prop.WILDCARDS);
        this.stemming = this.prop.is(Prop.STEMMING);
        this.diacritics = this.prop.is(Prop.DIACRITICS);
        this.casesens = this.prop.is(Prop.CASESENS);
        this.scoring = this.prop.num(Prop.SCORING);
        this.language = Language.get(this.prop.get(Prop.LANGUAGE));
        this.users = new Users(false);
    }

    public static boolean found(String path, String db, MainProp mprop) {
        File file = mprop.dbpath(db);
        boolean exists = file.exists();
        if (!exists || path.equals(db)) {
            return exists;
        }
        IO io = IO.get(path);
        DataInput in = null;
        try {
            String k;
            in = new DataInput(MetaData.file(file, "inf"));
            boolean ok = true;
            int i = 3;
            while (i != 0 && !(k = Token.string(in.readBytes())).isEmpty()) {
                String v = Token.string(in.readBytes());
                if (k.equals("STORAGE")) {
                    ok &= "5.91".equals(v);
                    --i;
                    continue;
                }
                if (k.equals("FNAME")) {
                    ok &= io.eq(IO.get(v));
                    --i;
                    continue;
                }
                if (!k.equals("TIME")) continue;
                ok &= io.date() == Token.toLong(v);
                --i;
            }
            boolean bl = i == 0 && ok;
            return bl;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public long dbsize() {
        long len = 0L;
        if (this.path != null) {
            File[] fileArray = this.path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File io = fileArray[n2];
                len += io.length();
                ++n2;
            }
        }
        return len;
    }

    public File dbfile(String fn) {
        return MetaData.file(this.path, fn);
    }

    public synchronized boolean drop(String pat) {
        return this.path != null && DropDB.drop(this.path, String.valueOf(pat) + ".basex");
    }

    public void read(DataInput in) throws IOException {
        String k;
        String storage = "";
        String istorage = "";
        while (!(k = Token.string(in.readBytes())).isEmpty()) {
            if (k.equals("PERM")) {
                this.users.read(in);
                continue;
            }
            String v = Token.string(in.readBytes());
            if (k.equals("STORAGE")) {
                storage = v;
                continue;
            }
            if (k.equals("FNAME")) {
                this.original = v;
                continue;
            }
            if (k.equals("TIME")) {
                this.time = Token.toLong(v);
                continue;
            }
            if (k.equals("ISTORAGE")) {
                istorage = v;
                continue;
            }
            if (k.equals("SIZE")) {
                this.size = Token.toInt(v);
                continue;
            }
            if (k.equals("FSIZE")) {
                this.filesize = Token.toLong(v);
                continue;
            }
            if (k.equals("NDOCS")) {
                this.ndocs = Token.toInt(v);
                continue;
            }
            if (k.equals("FTDC")) {
                this.diacritics = this.toBool(v);
                continue;
            }
            if (k.equals("ENCODING")) {
                this.encoding = v;
                continue;
            }
            if (k.equals("CHOPPED")) {
                this.chop = this.toBool(v);
                continue;
            }
            if (k.equals("PTHINDEX")) {
                this.pathindex = this.toBool(v);
                continue;
            }
            if (k.equals("TXTINDEX")) {
                this.textindex = this.toBool(v);
                continue;
            }
            if (k.equals("ATVINDEX")) {
                this.attrindex = this.toBool(v);
                continue;
            }
            if (k.equals("FTXINDEX")) {
                this.ftindex = this.toBool(v);
                continue;
            }
            if (k.equals("WCINDEX")) {
                this.wildcards = this.toBool(v);
                continue;
            }
            if (k.equals("FTSTEM")) {
                this.stemming = this.toBool(v);
                continue;
            }
            if (k.equals("FTCS")) {
                this.casesens = this.toBool(v);
                continue;
            }
            if (k.equals("FTDC")) {
                this.diacritics = this.toBool(v);
                continue;
            }
            if (k.equals("FTLANG")) {
                this.language = Language.get(v);
                continue;
            }
            if (k.equals("FTSCMAX")) {
                this.maxscore = Token.toInt(v);
                continue;
            }
            if (k.equals("FTSCMIN")) {
                this.minscore = Token.toInt(v);
                continue;
            }
            if (k.equals("FTSCTYPE")) {
                this.scoring = Token.toInt(v);
                continue;
            }
            if (k.equals("UPTODATE")) {
                this.uptodate = this.toBool(v);
                continue;
            }
            if (!k.equals("LASTID")) continue;
            this.lastid = Token.toInt(v);
        }
        if (!storage.equals("5.91")) {
            throw new BuildException(Text.DBUPDATE, storage);
        }
        if (!istorage.equals("5.91")) {
            this.oldindex = true;
            this.update();
        }
    }

    void write(DataOutput out) throws IOException {
        this.writeInfo(out, "STORAGE", "5.91");
        this.writeInfo(out, "FNAME", this.original);
        this.writeInfo(out, "TIME", this.time);
        this.writeInfo(out, "ISTORAGE", "5.91");
        this.writeInfo(out, "FSIZE", this.filesize);
        this.writeInfo(out, "NDOCS", this.ndocs);
        this.writeInfo(out, "ENCODING", this.encoding);
        this.writeInfo(out, "SIZE", this.size);
        this.writeInfo(out, "CHOPPED", this.chop);
        this.writeInfo(out, "PTHINDEX", this.pathindex);
        this.writeInfo(out, "TXTINDEX", this.textindex);
        this.writeInfo(out, "ATVINDEX", this.attrindex);
        this.writeInfo(out, "FTXINDEX", this.ftindex);
        this.writeInfo(out, "WCINDEX", this.wildcards);
        this.writeInfo(out, "FTSTEM", this.stemming);
        this.writeInfo(out, "FTCS", this.casesens);
        this.writeInfo(out, "FTDC", this.diacritics);
        this.writeInfo(out, "FTSCMAX", this.maxscore);
        this.writeInfo(out, "FTSCMIN", this.minscore);
        this.writeInfo(out, "FTSCTYPE", this.scoring);
        this.writeInfo(out, "UPTODATE", this.uptodate);
        this.writeInfo(out, "LASTID", this.lastid);
        if (this.language != null) {
            this.writeInfo(out, "FTLANG", this.language.name());
        }
        out.writeString("PERM");
        this.users.write(out);
        out.write(0);
    }

    void update() {
        this.time = System.currentTimeMillis();
        this.uptodate = false;
        this.dirty = true;
        this.textindex = false;
        this.attrindex = false;
        this.ftindex = false;
    }

    private boolean toBool(String v) {
        return v.equals("1");
    }

    private void writeInfo(DataOutput out, String k, boolean pr) throws IOException {
        this.writeInfo(out, k, pr ? "1" : "0");
    }

    private void writeInfo(DataOutput out, String k, long v) throws IOException {
        this.writeInfo(out, k, Long.toString(v));
    }

    private void writeInfo(DataOutput out, String k, String v) throws IOException {
        out.writeString(k);
        out.writeString(v);
    }

    private static File file(File path, String fn) {
        return new File(path, String.valueOf(fn) + ".basex");
    }
}

