/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.Index;
import org.basex.index.IndexToken;
import org.basex.index.Names;
import org.basex.index.ft.FTIndex;
import org.basex.index.path.PathSummary;
import org.basex.index.value.DiskValues;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Token;
import org.basex.util.Util;

public final class DiskData
extends Data {
    private final Compress comp = new Compress();
    private DataAccess texts;
    private DataAccess values;

    public DiskData(String db, Context ctx) throws IOException {
        this.meta = new MetaData(db, ctx);
        int cats = ctx.prop.num(Prop.CATEGORIES);
        DataInput in = new DataInput(this.meta.dbfile("inf"));
        try {
            String k;
            this.meta.read(in);
            while (!(k = Token.string(in.readBytes())).isEmpty()) {
                if (k.equals("TAGS")) {
                    this.tagindex = new Names(in, cats);
                    continue;
                }
                if (k.equals("ATTS")) {
                    this.atnindex = new Names(in, cats);
                    continue;
                }
                if (k.equals("PATH")) {
                    this.pthindex = new PathSummary(in);
                    continue;
                }
                if (k.equals("NS")) {
                    this.ns = new Namespaces(in);
                    continue;
                }
                if (!k.equals("DOCS")) continue;
                this.docindex.read(in);
            }
            this.init();
            if (this.meta.textindex) {
                this.txtindex = new DiskValues(this, true);
            }
            if (this.meta.attrindex) {
                this.atvindex = new DiskValues(this, false);
            }
            if (this.meta.ftindex) {
                this.ftxindex = FTIndex.get(this, this.meta.wildcards);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public DiskData(MetaData md, Names nm, Names at, PathSummary ps, Namespaces n) throws IOException {
        this.meta = md;
        this.tagindex = nm;
        this.atnindex = at;
        this.pthindex = ps;
        this.ns = n;
        this.init();
        this.flush();
    }

    @Override
    public void init() throws IOException {
        this.table = new TableDiskAccess(this.meta, "tbl");
        this.texts = new DataAccess(this.meta.dbfile("txt"));
        this.values = new DataAccess(this.meta.dbfile("atv"));
        super.init();
    }

    private void write() throws IOException {
        DataOutput out = new DataOutput(this.meta.dbfile("inf"));
        this.meta.write(out);
        out.writeString("TAGS");
        this.tagindex.write(out);
        out.writeString("ATTS");
        this.atnindex.write(out);
        out.writeString("PATH");
        this.pthindex.write(out);
        out.writeString("NS");
        this.ns.write(out);
        out.writeString("DOCS");
        this.docindex.write(out);
        out.write(0);
        out.close();
    }

    @Override
    public synchronized void flush() {
        try {
            if (this.meta.dirty) {
                this.write();
            }
            this.table.flush();
            this.texts.flush();
            this.values.flush();
            this.meta.dirty = false;
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.table.close();
        this.texts.close();
        this.values.close();
        this.closeIndex(IndexToken.IndexType.TEXT);
        this.closeIndex(IndexToken.IndexType.ATTRIBUTE);
        this.closeIndex(IndexToken.IndexType.FULLTEXT);
    }

    @Override
    public synchronized void closeIndex(IndexToken.IndexType type) throws IOException {
        switch (type) {
            case TEXT: {
                if (this.txtindex == null) break;
                this.txtindex.close();
                this.txtindex = null;
                break;
            }
            case ATTRIBUTE: {
                if (this.atvindex == null) break;
                this.atvindex.close();
                this.atvindex = null;
                break;
            }
            case FULLTEXT: {
                if (this.ftxindex == null) break;
                this.ftxindex.close();
                this.ftxindex = null;
                break;
            }
        }
    }

    @Override
    public void setIndex(IndexToken.IndexType type, Index index) {
        this.meta.dirty = true;
        switch (type) {
            case TEXT: {
                this.txtindex = index;
                break;
            }
            case ATTRIBUTE: {
                this.atvindex = index;
                break;
            }
            case FULLTEXT: {
                this.ftxindex = index;
                break;
            }
            case PATH: {
                this.pthindex = (PathSummary)index;
                break;
            }
        }
    }

    @Override
    public byte[] text(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? Token.token((int)o) : this.txt(o, text);
    }

    @Override
    public long textItr(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? o & 0x7FFFFFFFFFL : Token.toLong(this.txt(o, text));
    }

    @Override
    public double textDbl(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? (double)(o & 0x7FFFFFFFFFL) : Token.toDouble(this.txt(o, text));
    }

    @Override
    public int textLen(int pre, boolean text) {
        long o = this.textOff(pre);
        if (DiskData.num(o)) {
            return Token.numDigits((int)o);
        }
        DataAccess da = text ? this.texts : this.values;
        int l = da.readNum(o & 0x3FFFFFFFFFL);
        return DiskData.cpr(o) ? da.readNum() : l;
    }

    private byte[] txt(long o, boolean text) {
        byte[] txt = (text ? this.texts : this.values).readToken(o & 0x3FFFFFFFFFL);
        return DiskData.cpr(o) ? this.comp.unpack(txt) : txt;
    }

    private static boolean num(long o) {
        return (o & 0x8000000000L) != 0L;
    }

    private static boolean cpr(long o) {
        return (o & 0x4000000000L) != 0L;
    }

    @Override
    protected void text(int pre, byte[] val, boolean txt) {
        long v = Token.toSimpleInt(val);
        if (v != Integer.MIN_VALUE) {
            this.textOff(pre, v | 0x8000000000L);
        } else {
            DataAccess da = txt ? this.texts : this.values;
            byte[] pack = this.comp.pack(val);
            long old = this.textOff(pre);
            long o = old & 0x3FFFFFFFFFL;
            if (!DiskData.num(old)) {
                int len = da.readNum(o);
                if (da.pos() + (long)len == da.length()) {
                    da.length(da.pos() + (long)pack.length);
                } else if (pack.length > len) {
                    o = da.length();
                }
            } else {
                o = da.length();
            }
            da.writeBytes(o, pack);
            this.textOff(pre, o | (pack == val ? 0L : 0x4000000000L));
        }
    }

    @Override
    protected long index(byte[] txt, int pre, boolean text) {
        DataAccess da = text ? this.texts : this.values;
        long off = da.length();
        da.writeBytes(off, txt);
        return off;
    }
}

