/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.util.Util;

public final class ShowUsers
extends Command {
    public ShowUsers() {
        this(null);
    }

    public ShowUsers(String db) {
        super(8, db);
    }

    @Override
    protected boolean run() throws IOException {
        String name = this.args[0];
        if (name != null && !ShowUsers.validName(name, false)) {
            return this.error(Text.NAMEINVALID, name);
        }
        if (name != null) {
            try {
                Data data = Open.open(name, this.context);
                this.out.println(data.meta.users.info(this.context.users));
                Close.close(data, this.context);
                return true;
            }
            catch (IOException ex) {
                Util.debug(ex);
                String msg = ex.getMessage();
                return msg.isEmpty() ? this.error(Text.DBOPENERR, name) : this.error(msg, new Object[0]);
            }
        }
        this.out.println(this.context.users.info(null));
        return true;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.SHOW) + " " + (Object)((Object)Commands.CmdShow.USERS)).arg("ON", 0);
    }
}

