/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.util.Util;

public final class Open
extends Command {
    public Open(String path) {
        super(256, path);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        new Close().run(this.context);
        int i = db.indexOf(47);
        String path = null;
        if (i != -1) {
            path = db.substring(i + 1);
            db = db.substring(0, i);
        }
        if (!Open.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        try {
            Data data = Open.open(db, this.context);
            this.context.openDB(data, path);
            if (data.meta.oldindex) {
                this.info(Text.INDUPDATE, new Object[0]);
            }
            return this.info(Text.DBOPENED, db, this.perf);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return msg.isEmpty() ? this.error(Text.DBOPENERR, db) : this.error(msg, new Object[0]);
        }
    }

    @Override
    public boolean newData(Context ctx) {
        new Close().run(ctx);
        return true;
    }

    public static synchronized Data open(String name, Context ctx) throws IOException {
        Data data = ctx.pin(name);
        if (data == null) {
            if (!ctx.mprop.dbexists(name)) {
                throw new IOException(Util.info(Text.DBNOTFOUND, name));
            }
            data = new DiskData(name, ctx);
            ctx.pin(data);
        }
        if (ctx.perm(1, data.meta)) {
            return data;
        }
        Close.close(data, ctx);
        throw new IOException(Util.info(Text.PERMNO, new Object[]{Commands.CmdPerm.READ}));
    }
}

