/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashSet;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.XMLSerializer;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class Export
extends Command {
    public Export(String path) {
        super(516, path);
    }

    @Override
    protected boolean run() {
        try {
            Data data = this.context.data;
            Export.export(this.prop, data, this.args[0]);
            return this.info(Text.DBEXPORTED, data.meta.name, this.perf);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(ex.getMessage(), new Object[0]);
        }
    }

    public static void export(Prop prop, Data data, String target) throws IOException {
        SerializerProp sp = new SerializerProp(prop.get(Prop.EXPORTER));
        IOFile root = new IOFile(target);
        root.md();
        HashSet<String> exported = new HashSet<String>();
        IntList il = data.doc();
        int i = 0;
        int is = il.size();
        while (i < is) {
            String fp;
            int pre = il.get(i);
            IOFile file = root.merge(Token.string(data.text(pre, true)));
            IOFile dir = new IOFile(file.dir());
            if (!dir.exists()) {
                dir.md();
            }
            String path = fp = file.path();
            int c = 1;
            while (exported.contains(path)) {
                String string = path = fp.indexOf(46) == -1 ? String.valueOf(fp) + '(' + ++c + ')' : fp.replaceAll("(.*)\\.(.*)", "$1(" + ++c + ").$2");
            }
            exported.add(fp);
            PrintOutput po = new PrintOutput(path);
            XMLSerializer xml = new XMLSerializer(po, sp);
            xml.node(data, pre);
            xml.close();
            po.close();
            ++i;
        }
    }
}

