/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.BuildException;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.SAXWrapper;
import org.basex.core.BaseXException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.index.IndexToken;
import org.basex.index.ft.FTBuilder;
import org.basex.index.value.ValueBuilder;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.BufferInput;
import org.basex.util.Performance;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class CreateDB
extends ACreate {
    private final Parser parser;

    public CreateDB(String name) {
        this(name, (String)null);
    }

    public CreateDB(String name, String input) {
        this(name, input, (Parser)null);
    }

    public CreateDB(String name, String input, Parser p) {
        super(name, input);
        this.parser = p;
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        String input = this.args[1];
        if (input == null) {
            return this.build(Parser.emptyParser(), name);
        }
        IO io = IO.get(input);
        if (io instanceof IOContent) {
            io.name(String.valueOf(name) + ".xml");
        }
        Parser p = this.parser != null ? this.parser : new DirParser(io, this.prop);
        return io.exists() ? this.build(p, name) : this.error(Text.FILEWHICH, io);
    }

    public static synchronized String create(String name, InputStream input, Context ctx) throws BaseXException {
        InputStream is = input instanceof BufferedInputStream || input instanceof BufferInput ? input : new BufferedInputStream(input);
        SAXSource sax = new SAXSource(new InputSource(is));
        return CreateDB.create(name, new SAXWrapper(sax, "", ctx.prop), ctx);
    }

    public static synchronized String create(String name, Parser parser, Context ctx) throws BaseXException {
        Performance p = new Performance();
        ctx.register(true);
        try {
            try {
                Data data = ctx.data;
                if (data != null) {
                    Close.close(data, ctx);
                    ctx.closeDB();
                }
                ctx.openDB(CreateDB.xml(name, parser, ctx));
            }
            catch (IOException ex) {
                throw new BaseXException(ex);
            }
        }
        finally {
            ctx.unregister(true);
        }
        return Util.info(Text.DBCREATED, name, p);
    }

    public static Data empty(String name, Context ctx) throws IOException {
        return CreateDB.xml(name, Parser.emptyParser(), ctx);
    }

    public static synchronized Data xml(String name, IO source, Context ctx) throws IOException {
        if (!source.exists()) {
            throw new BuildException(Text.FILEWHICH, source);
        }
        return CreateDB.xml(name, new DirParser(source, ctx.prop), ctx);
    }

    public static synchronized Data xml(String name, Parser parser, Context ctx) throws IOException {
        if (!ctx.user.perm(4)) {
            throw new IOException(Util.info(Text.PERMNO, new Object[]{Commands.CmdPerm.CREATE}));
        }
        Prop prop = ctx.prop;
        if (prop.is(Prop.MAINMEM)) {
            return MemBuilder.build(name, parser, ctx.prop);
        }
        if (ctx.pinned(name)) {
            throw new IOException(Util.info(Text.DBLOCKED, name));
        }
        DiskBuilder builder = new DiskBuilder(name, parser, ctx);
        try {
            Data data = ((Builder)builder).build();
            if (prop.is(Prop.TEXTINDEX)) {
                data.setIndex(IndexToken.IndexType.TEXT, new ValueBuilder(data, true).build());
            }
            if (prop.is(Prop.ATTRINDEX)) {
                data.setIndex(IndexToken.IndexType.ATTRIBUTE, new ValueBuilder(data, false).build());
            }
            if (prop.is(Prop.FTINDEX)) {
                data.setIndex(IndexToken.IndexType.FULLTEXT, FTBuilder.get(data).build());
            }
            data.close();
        }
        finally {
            try {
                ((Builder)builder).close();
            }
            catch (IOException exx) {
                Util.debug(exx);
            }
        }
        return Open.open(name, ctx);
    }

    public static synchronized Data xml(Parser parser, Context ctx) throws IOException {
        if (!ctx.user.perm(4)) {
            throw new IOException(Util.info(Text.PERMNO, new Object[]{Commands.CmdPerm.CREATE}));
        }
        return MemBuilder.build(parser, ctx.prop);
    }

    public static synchronized Data xml(IO source, Context ctx) throws IOException {
        if (!source.exists()) {
            throw new BuildException(Text.FILEWHICH, source.path());
        }
        return CreateDB.xml(new DirParser(source, ctx.prop), ctx);
    }

    public static synchronized Data xml(SAXSource source, Context ctx) throws IOException {
        return CreateDB.xml(new SAXWrapper(source, "", ctx.prop), ctx);
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.DB)).args();
    }
}

