/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.SAXWrapper;
import org.basex.core.BaseXException;
import org.basex.core.CommandBuilder;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.util.Performance;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class Add
extends ACreate {
    private Builder build;

    public Add(String input) {
        this(input, (String)null);
    }

    public Add(String input, String name) {
        this(input, name, (String)null);
    }

    public Add(String input, String name, String target) {
        super(514, input, name, target == null ? "" : target);
    }

    @Override
    protected boolean run() {
        String input = this.args[0];
        IO io = IO.get(input);
        if (!io.exists()) {
            return this.error(Text.FILEWHICH, io);
        }
        String name = this.args[1];
        if (name != null && !name.isEmpty()) {
            if (name.matches(".*[\\\\/].*")) {
                return this.error(Text.NAMEINVALID, this.args[1]);
            }
            io.name(name);
        } else if (io instanceof IOContent) {
            name = String.valueOf(this.context.data.meta.name) + ".xml";
            io.name(name);
        }
        String trg = Add.path(this.args[2]);
        DirParser p = new DirParser(io, trg, this.prop);
        try {
            return this.info(Add.add(p, this.context, trg, name, this), new Object[0]);
        }
        catch (BaseXException ex) {
            return this.error(ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init().arg("AS", 1).arg("TO", 2).arg(0);
    }

    public static String add(String name, String target, InputSource input, Context ctx, Add cmd, boolean lock) throws BaseXException {
        Data data = ctx.data;
        if (data == null) {
            return Text.PROCNODB;
        }
        String trg = Add.path(target);
        if (!trg.isEmpty()) {
            trg = String.valueOf(trg) + '/';
        }
        SAXSource sax = new SAXSource(input);
        SAXWrapper parser = new SAXWrapper(sax, name, trg, ctx.prop);
        try {
            if (lock) {
                ctx.register(true);
            }
            String string = Add.add(parser, ctx, trg, name, cmd);
            return string;
        }
        finally {
            if (lock) {
                ctx.unregister(true);
            }
        }
    }

    private static String add(Parser parser, Context ctx, String target, String name, Add cmd) throws BaseXException {
        Builder build;
        Performance p = new Performance();
        String input = name == null ? parser.src.path() : name;
        String path = String.valueOf(target) + (target.isEmpty() ? "/" : "") + (name == null ? parser.src.name() : name);
        long fl = parser.src.length();
        boolean large = false;
        Runtime rt = Runtime.getRuntime();
        if (fl > rt.freeMemory() / 3L) {
            Performance.gc(2);
            large = fl > rt.freeMemory() / 3L;
        }
        Data data = ctx.data;
        String dbname = large ? ctx.mprop.random(data.meta.name) : path;
        Builder builder = build = large ? new DiskBuilder(dbname, parser, ctx) : new MemBuilder(dbname, parser, ctx.prop);
        if (cmd != null) {
            cmd.build = build;
        }
        Data tmp = null;
        try {
            tmp = build.build();
            if (tmp.meta.size > 1) {
                data.insert(data.meta.size, -1, tmp);
                ctx.update();
                data.flush();
            }
            String string = Util.info(String.valueOf(parser.info()) + Text.PATHADDED, input, p);
            return string;
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw new BaseXException(ex);
        }
        finally {
            try {
                build.close();
            }
            catch (IOException iOException) {}
            if (tmp != null) {
                try {
                    tmp.close();
                }
                catch (IOException iOException) {}
            }
            if (large) {
                DropDB.drop(dbname, ctx.mprop);
            }
        }
    }

    @Override
    protected String tit() {
        return Text.BUTTONADD;
    }

    @Override
    protected double prog() {
        return this.build != null ? this.build.prog() : 0.0;
    }
}

