/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.SingleParser;
import org.basex.build.xml.CatalogWrapper;
import org.basex.build.xml.SAXHandler;
import org.basex.core.ProgressException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAXWrapper
extends SingleParser {
    private static final String EXTDTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String LEXHANDLER = "http://xml.org/sax/properties/lexical-handler";
    long counter;
    int line = 1;
    private SAXHandler saxh;
    private final SAXSource saxs;
    private long length;
    private final Prop prop;

    public SAXWrapper(SAXSource source, String target, Prop pr) {
        super(IO.get(source.getSystemId()), target);
        this.saxs = source;
        this.prop = pr;
    }

    public SAXWrapper(SAXSource source, String name, String target, Prop pr) {
        this(source, target, pr);
        this.src.name(name);
    }

    @Override
    public void parse() throws IOException {
        InputSource is = this.wrap(this.saxs.getInputSource());
        String in = this.saxs.getSystemId() == null ? "..." : this.saxs.getSystemId();
        try {
            try {
                XMLReader r = this.saxs.getXMLReader();
                if (r == null) {
                    SAXParserFactory f = SAXParserFactory.newInstance();
                    f.setFeature(EXTDTD, this.prop.is(Prop.DTD));
                    f.setFeature("http://xml.org/sax/features/use-entity-resolver2", false);
                    f.setNamespaceAware(true);
                    f.setValidating(false);
                    f.setXIncludeAware(true);
                    r = f.newSAXParser().getXMLReader();
                }
                this.saxh = new SAXHandler(this.builder);
                String cat = this.prop.get(Prop.CATFILE);
                if (!cat.isEmpty()) {
                    CatalogWrapper.set(r, cat);
                }
                r.setDTDHandler(this.saxh);
                r.setContentHandler(this.saxh);
                r.setProperty(LEXHANDLER, this.saxh);
                r.setErrorHandler(this.saxh);
                if (is != null) {
                    r.parse(is);
                } else {
                    r.parse(this.saxs.getSystemId());
                }
            }
            catch (SAXParseException ex) {
                String msg = String.valueOf(Util.info(Text.SCANPOS, in, ex.getLineNumber(), ex.getColumnNumber())) + ": " + ex.getMessage();
                IOException ioe = new IOException(msg);
                ioe.setStackTrace(ex.getStackTrace());
                throw ioe;
            }
            catch (ProgressException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (in != null) {
                    msg = "\"" + in + '\"' + ": " + msg;
                }
                IOException ioe = new IOException(msg);
                ioe.setStackTrace(ex.getStackTrace());
                throw ioe;
            }
        }
        finally {
            try {
                Reader r;
                InputStream ist = is.getByteStream();
                if (ist != null) {
                    ist.close();
                }
                if ((r = is.getCharacterStream()) != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
    }

    private InputSource wrap(InputSource is) throws IOException {
        InputStream in;
        if (is == null) {
            return is;
        }
        if (is.getByteStream() != null) {
            in = is.getByteStream();
        } else {
            if (is.getSystemId() == null || is.getSystemId().isEmpty()) {
                return is;
            }
            if (this.src instanceof IOFile) {
                in = new FileInputStream(this.src.path());
            } else if (this.src instanceof IOContent) {
                in = new ByteArrayInputStream(this.src.content());
            } else {
                return is;
            }
        }
        this.length = this.src.length();
        if (this.length == 0L) {
            this.length = in.available();
        }
        InputSource tmp = new InputSource(new InputStream(in){
            final InputStream buffer;
            {
                this.buffer = inputStream instanceof ByteArrayInputStream ? inputStream : new BufferedInputStream(inputStream);
            }

            @Override
            public int read() throws IOException {
                int i = this.buffer.read();
                if (i == 10) {
                    ++SAXWrapper.this.line;
                }
                ++SAXWrapper.this.counter;
                return i;
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
            }
        });
        this.saxs.setInputSource(tmp);
        this.saxs.setSystemId(is.getSystemId());
        return tmp;
    }

    @Override
    public String det() {
        return this.length == 0L ? super.det() : Util.info(Text.SCANPOS, this.src.name(), this.line);
    }

    @Override
    public double prog() {
        return this.length == 0L ? (this.saxh == null ? 0.0 : (double)this.saxh.nodes / 3000000.0 % 1.0) : (double)this.counter / (double)this.length;
    }
}

