/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.cmd.DropDB;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.out.TableOutput;
import org.basex.io.random.TableAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Token;
import org.basex.util.Util;

public final class DiskBuilder
extends Builder {
    private DataOutput tout;
    private DataOutput xout;
    private DataOutput vout;
    private DataOutput sout;
    private long txtlen;
    private long vallen;
    protected final MainProp mprop;
    private final Compress comp = new Compress();

    public DiskBuilder(String nm, Parser parse, Context ctx) {
        super(nm, parse, ctx.prop);
        this.mprop = ctx.mprop;
    }

    @Override
    public DiskData build() throws IOException {
        DropDB.drop(this.name, this.mprop);
        this.mprop.dbpath(this.name).mkdirs();
        IO file = this.parser.src;
        this.meta = new MetaData(this.name, this.prop, this.mprop);
        this.meta.original = file != null ? file.path() : "";
        this.meta.filesize = file != null ? file.length() : 0L;
        this.meta.time = file != null ? file.date() : System.currentTimeMillis();
        this.meta.dirty = true;
        Runtime rt = Runtime.getRuntime();
        int bs = (int)Math.min(this.meta.filesize, Math.min(0x400000L, rt.maxMemory() - rt.freeMemory() >> 2));
        bs = Math.max(4096, bs - bs % 4096);
        this.tout = new DataOutput(new TableOutput(this.meta, "tbl"));
        this.xout = new DataOutput(this.meta.dbfile("txt"), bs);
        this.vout = new DataOutput(this.meta.dbfile("atv"), bs);
        this.sout = new DataOutput(this.meta.dbfile("tmp"), bs);
        this.parse();
        this.close();
        TableDiskAccess ta = new TableDiskAccess(this.meta, "tbl");
        DataInput in = new DataInput(this.meta.dbfile("tmp"));
        while (this.spos < this.ssize) {
            ((TableAccess)ta).write4(in.readNum(), 8, in.readNum());
            ++this.spos;
        }
        ((TableAccess)ta).close();
        in.close();
        this.meta.dbfile("tmp").delete();
        return new DiskData(this.meta, this.tags, this.atts, this.path, this.ns);
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        DropDB.drop(this.meta.name, this.mprop);
    }

    @Override
    public void close() throws IOException {
        if (this.tout != null) {
            this.tout.close();
        }
        if (this.xout != null) {
            this.xout.close();
        }
        if (this.vout != null) {
            this.vout.close();
        }
        if (this.sout != null) {
            this.sout.close();
        }
        this.parser.close();
        this.tout = null;
        this.xout = null;
        this.vout = null;
        this.sout = null;
    }

    @Override
    protected void addDoc(byte[] value) throws IOException {
        this.tout.write1(0);
        this.tout.write2(0);
        this.tout.write5(this.textOff(value, true));
        this.tout.write4(0);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addElem(int dist, int nm, int asize, int uri, boolean ne) throws IOException {
        this.tout.write1(asize << 3 | 1);
        this.tout.write2((ne ? 32768 : 0) | nm);
        this.tout.write1(uri);
        this.tout.write4(dist);
        this.tout.write4(asize);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addAttr(int nm, byte[] value, int dist, int uri) throws IOException {
        this.tout.write1(dist << 3 | 3);
        this.tout.write2(nm);
        this.tout.write5(this.textOff(value, false));
        this.tout.write4(uri);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void addText(byte[] value, int dist, byte kind) throws IOException {
        this.tout.write1(kind);
        this.tout.write2(0);
        this.tout.write5(this.textOff(value, true));
        this.tout.write4(dist);
        this.tout.write4(this.meta.size++);
    }

    @Override
    protected void setSize(int pre, int size) throws IOException {
        this.sout.writeNum(pre);
        this.sout.writeNum(size);
        ++this.ssize;
    }

    private long textOff(byte[] value, boolean text) throws IOException {
        long v = Token.toSimpleInt(value);
        if (v != Integer.MIN_VALUE) {
            return v | 0x8000000000L;
        }
        byte[] cpr = this.comp.pack(value);
        if (text) {
            v = this.txtlen;
            this.txtlen += (long)this.xout.writeToken(cpr);
        } else {
            v = this.vallen;
            this.vallen += (long)this.vout.writeToken(cpr);
        }
        return cpr != value ? v | 0x4000000000L : v;
    }
}

