/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import org.basex.core.Main;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.XQuery;
import org.basex.io.IO;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.server.LocalSession;
import org.basex.server.Session;
import org.basex.util.Args;
import org.basex.util.Util;

public class BaseX
extends Main {
    private boolean writeProps;
    private String commands;
    private String file;
    protected String input;
    private String query;
    protected String user;
    protected String pass;

    public static void main(String ... args) {
        new BaseX(args);
    }

    protected BaseX(String ... args) {
        super(args);
        BaseX.check(this.success);
        this.run();
    }

    @Override
    public void run() {
        try {
            this.session();
            boolean u = false;
            if (this.input != null) {
                BaseX.check(this.execute(new Check(this.input), this.verbose));
            }
            if (this.file != null) {
                this.context.query = IO.get(this.file);
                String qu = this.content();
                BaseX.check(qu != null && this.execute(new XQuery(qu), this.verbose));
            } else if (this.query != null) {
                BaseX.check(this.execute(new XQuery(this.query), this.verbose));
            } else if (this.commands != null) {
                Boolean b = this.execute(this.commands);
                BaseX.check(b == null || b != false);
            } else {
                Util.outln(String.valueOf(Text.CONSOLE) + Text.CONSOLE2, this.sa() ? "Standalone" : "Client");
                u = this.console();
            }
            if (this.writeProps) {
                this.context.mprop.write();
            }
            this.quit(u);
        }
        catch (IOException ex) {
            Util.errln(Util.server(ex), new Object[0]);
            BaseX.check(false);
        }
    }

    private String content() {
        IO io = IO.get(this.file);
        if (!io.exists()) {
            Util.errln(String.valueOf(Text.INFOERROR) + Text.FILEWHICH, this.file);
        } else {
            try {
                return TextInput.content(io).toString().trim();
            }
            catch (IOException ex) {
                this.error(ex, ex.getMessage());
            }
        }
        return null;
    }

    protected boolean sa() {
        return true;
    }

    @Override
    protected Session session() throws IOException {
        if (this.session == null) {
            this.session = new LocalSession(this.context, this.out);
        }
        this.session.setOutputStream(this.out);
        return this.session;
    }

    @Override
    protected final boolean parseArguments(String[] args) {
        StringBuilder serial = new StringBuilder();
        StringBuilder bind = new StringBuilder();
        try {
            Args arg = new Args(args, this, this.sa() ? Text.LOCALINFO : Text.CLIENTINFO, Util.info(Text.CONSOLE, this.sa() ? "Standalone" : "Client"));
            while (arg.more()) {
                if (arg.dash()) {
                    char c = arg.next();
                    if (c == 'b') {
                        if (bind.length() != 0) {
                            bind.append(',');
                        }
                        bind.append(arg.string());
                        arg.check(this.set(Prop.BINDINGS, bind));
                        continue;
                    }
                    if (c == 'c') {
                        this.commands = arg.remaining();
                        continue;
                    }
                    if (c == 'd') {
                        this.context.mprop.set(MainProp.DEBUG, true);
                        continue;
                    }
                    if (c == 'D' && this.sa()) {
                        arg.check(this.set(Prop.DOTPLAN, true));
                        continue;
                    }
                    if (c == 'i' && this.sa()) {
                        this.input = arg.string();
                        continue;
                    }
                    if (c == 'n' && !this.sa()) {
                        this.context.mprop.set(MainProp.HOST, arg.string());
                        continue;
                    }
                    if (c == 'o') {
                        this.out = new PrintOutput(arg.string());
                        if (this.session == null) continue;
                        this.session.setOutputStream(this.out);
                        continue;
                    }
                    if (c == 'p' && !this.sa()) {
                        this.context.mprop.set(MainProp.PORT, arg.num());
                        continue;
                    }
                    if (c == 'P' && !this.sa()) {
                        this.pass = arg.string();
                        continue;
                    }
                    if (c == 'q') {
                        this.query = arg.remaining();
                        continue;
                    }
                    if (c == 'r') {
                        arg.check(this.set(Prop.RUNS, arg.string()));
                        continue;
                    }
                    if (c == 's') {
                        if (serial.length() != 0) {
                            serial.append(',');
                        }
                        serial.append(arg.string());
                        arg.check(this.set(Prop.SERIALIZER, serial));
                        continue;
                    }
                    if (c == 'u') {
                        arg.check(this.set(Prop.WRITEBACK, true));
                        continue;
                    }
                    if (c == 'U' && !this.sa()) {
                        this.user = arg.string();
                        continue;
                    }
                    if (c == 'v') {
                        this.verbose = true;
                        continue;
                    }
                    if (c == 'V') {
                        this.verbose = true;
                        arg.check(this.set(Prop.QUERYINFO, true));
                        continue;
                    }
                    if (c == 'w') {
                        arg.check(this.set(Prop.CHOP, false));
                        continue;
                    }
                    if (c == 'W') {
                        this.writeProps = true;
                        continue;
                    }
                    if (c == 'x' && this.sa()) {
                        arg.check(this.set(Prop.COMPPLAN, false));
                        continue;
                    }
                    if (c == 'X') {
                        arg.check(this.set(Prop.XMLPLAN, true));
                        this.verbose = true;
                        continue;
                    }
                    if (c == 'z') {
                        arg.check(this.set(Prop.SERIALIZE, false));
                        continue;
                    }
                    arg.check(false);
                    continue;
                }
                String string = this.file = this.file == null ? arg.string() : String.valueOf(this.file) + " " + arg.string();
            }
            this.console = this.file == null && this.commands == null && this.query == null;
            return arg.finish();
        }
        catch (IOException ex) {
            Util.errln(Util.server(ex), new Object[0]);
            return false;
        }
    }
}

