/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.util.Locale;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.AbstractComponentMapper;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractResourceReferenceMapper
extends AbstractComponentMapper {
    protected static String encodeResourceReferenceAttributes(ResourceReference.UrlAttributes attributes) {
        boolean styleEmpty;
        if (attributes == null || attributes.getLocale() == null && attributes.getStyle() == null && attributes.getVariation() == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        if (attributes.getLocale() != null) {
            res.append(attributes.getLocale().toString());
        }
        if (!(styleEmpty = Strings.isEmpty((CharSequence)attributes.getStyle()))) {
            res.append('-');
            res.append(attributes.getStyle());
        }
        if (!Strings.isEmpty((CharSequence)attributes.getVariation())) {
            if (styleEmpty) {
                res.append("--");
            } else {
                res.append('-');
            }
            res.append(attributes.getVariation());
        }
        return res.toString();
    }

    private static String nonEmpty(String s) {
        if (Strings.isEmpty((CharSequence)s)) {
            return null;
        }
        return s;
    }

    protected static ResourceReference.UrlAttributes decodeResourceReferenceAttributes(String attributes) {
        Locale locale = null;
        String style = null;
        String variation = null;
        if (!Strings.isEmpty((CharSequence)attributes)) {
            String[] split = attributes.split("-", 3);
            locale = AbstractResourceReferenceMapper.parseLocale(split[0]);
            if (split.length == 2) {
                style = AbstractResourceReferenceMapper.nonEmpty(split[1]);
            } else if (split.length == 3) {
                style = AbstractResourceReferenceMapper.nonEmpty(split[1]);
                variation = AbstractResourceReferenceMapper.nonEmpty(split[2]);
            }
        }
        return new ResourceReference.UrlAttributes(locale, style, variation);
    }

    private static Locale parseLocale(String locale) {
        if (Strings.isEmpty((CharSequence)locale)) {
            return null;
        }
        String[] parts = locale.toLowerCase().split("_", 3);
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        if (parts.length == 2) {
            return new Locale(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new Locale(parts[0], parts[1], parts[2]);
        }
        return null;
    }

    protected void encodeResourceReferenceAttributes(Url url, ResourceReference reference) {
        String encoded = AbstractResourceReferenceMapper.encodeResourceReferenceAttributes(reference.getUrlAttributes());
        if (!Strings.isEmpty((CharSequence)encoded)) {
            url.getQueryParameters().add(new Url.QueryParameter(encoded, ""));
        }
    }

    protected ResourceReference.UrlAttributes getResourceReferenceAttributes(Url url) {
        Url.QueryParameter param;
        Args.notNull((Object)url, (String)"url");
        if (url.getQueryParameters().size() > 0 && Strings.isEmpty((CharSequence)(param = (Url.QueryParameter)url.getQueryParameters().get(0)).getValue())) {
            return AbstractResourceReferenceMapper.decodeResourceReferenceAttributes(param.getName());
        }
        return new ResourceReference.UrlAttributes(null, null, null);
    }

    protected void removeMetaParameter(Url urlCopy) {
        urlCopy.getQueryParameters().remove(0);
    }
}

