/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.request.UrlDecoder;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.Strings;

public final class RequestUtils {
    public static void decodeParameters(String queryString, PageParameters params) {
        for (String paramTuple : Strings.split((String)queryString, (char)'&')) {
            String[] bits = Strings.split((String)paramTuple, (char)'=');
            if (bits.length == 2) {
                params.add(UrlDecoder.QUERY_INSTANCE.decode(bits[0], RequestUtils.getCurrentCharset()), (Object)UrlDecoder.QUERY_INSTANCE.decode(bits[1], RequestUtils.getCurrentCharset()));
                continue;
            }
            params.add(UrlDecoder.QUERY_INSTANCE.decode(bits[0], RequestUtils.getCurrentCharset()), (Object)"");
        }
    }

    public static String removeDoubleDots(String path) {
        ArrayList<String> newcomponents = new ArrayList<String>(Arrays.asList(path.split("/")));
        for (int i = 0; i < newcomponents.size(); ++i) {
            if (i >= newcomponents.size() - 1 || ((String)newcomponents.get(i)).length() <= 0 || !((String)newcomponents.get(i + 1)).equals("..")) continue;
            newcomponents.remove(i);
            newcomponents.remove(i);
            if ((i -= 2) >= -1) continue;
            i = -1;
        }
        String newpath = Strings.join((String)"/", (String[])newcomponents.toArray(new String[newcomponents.size()]));
        if (path.endsWith("/")) {
            return newpath + "/";
        }
        return newpath;
    }

    private RequestUtils() {
    }

    public static String toAbsolutePath(String requestPath, String relativePagePath) {
        StringBuilder result = requestPath.endsWith("/") ? new StringBuilder(requestPath) : new StringBuilder(requestPath.substring(0, requestPath.lastIndexOf(47) + 1));
        if (relativePagePath.startsWith("./")) {
            relativePagePath = relativePagePath.substring(2);
        }
        if (relativePagePath.startsWith("../")) {
            StringBuilder tempRelative = new StringBuilder(relativePagePath);
            while (tempRelative.indexOf("../") == 0) {
                tempRelative.delete(0, 3);
                result.setLength(result.length() - 1);
                result.delete(result.lastIndexOf("/") + 1, result.length());
            }
            result.append((CharSequence)tempRelative);
        } else {
            result.append(relativePagePath);
        }
        return result.toString();
    }

    private static Charset getDefaultCharset() {
        String charsetName = null;
        if (Application.exists()) {
            charsetName = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        }
        if (Strings.isEmpty(charsetName)) {
            charsetName = "UTF-8";
        }
        return Charset.forName(charsetName);
    }

    private static Charset getCurrentCharset() {
        return RequestCycle.get().getRequest().getCharset();
    }

    public static Charset getCharset(HttpServletRequest request) {
        String charsetName;
        Charset charset = null;
        if (request != null && (charsetName = request.getCharacterEncoding()) != null) {
            charset = Charset.forName(charsetName);
        }
        if (charset == null) {
            charset = RequestUtils.getDefaultCharset();
        }
        return charset;
    }
}

