/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.Component;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.request.Response;

public class HtmlSpecialTag
extends MarkupElement {
    protected final XmlTag xmlTag;
    private int flags = 0;
    private final IXmlPullParser.HttpTagType httpTagType;

    public HtmlSpecialTag(XmlTag tag, IXmlPullParser.HttpTagType httpTagType) {
        this.xmlTag = tag.makeImmutable();
        this.httpTagType = httpTagType;
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public final int getLength() {
        return this.xmlTag.getLength();
    }

    public final int getPos() {
        return this.xmlTag.getPos();
    }

    public final XmlTag.TagType getType() {
        return this.xmlTag.getType();
    }

    public final boolean isClose() {
        return this.xmlTag.isClose();
    }

    public final boolean isOpen() {
        return this.xmlTag.isOpen();
    }

    public final boolean isOpenClose() {
        return this.xmlTag.isOpenClose();
    }

    void copyPropertiesTo(HtmlSpecialTag dest) {
        dest.flags = this.flags;
    }

    public CharSequence toCharSequence() {
        return this.xmlTag.toCharSequence();
    }

    public final String toString() {
        return "" + (Object)((Object)this.httpTagType) + ": '" + this.xmlTag.toString() + "'";
    }

    public final void writeOutput(Response response, boolean stripWicketAttributes, String namespace) {
        response.write((CharSequence)this.toString());
    }

    public final String toUserDebugString() {
        return this.xmlTag.toUserDebugString();
    }

    public final XmlTag getXmlTag() {
        return this.xmlTag;
    }

    public boolean equalTo(MarkupElement element) {
        if (element instanceof HtmlSpecialTag) {
            HtmlSpecialTag that = (HtmlSpecialTag)element;
            return this.getXmlTag().equalTo(that.getXmlTag());
        }
        return false;
    }

    public void onBeforeRender(Component component, MarkupStream markupStream) {
    }

    public final IXmlPullParser.HttpTagType getHttpTagType() {
        return this.httpTagType;
    }
}

