/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html;

import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.CancelEventIfNoAjaxDecorator;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AjaxFallbackLink<T>
extends Link<T>
implements IAjaxLink {
    private static final long serialVersionUID = 1L;

    public AjaxFallbackLink(String id) {
        this(id, (IModel<T>)null);
    }

    public AjaxFallbackLink(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxEventBehavior("onclick"));
    }

    protected AjaxEventBehavior newAjaxEventBehavior(String event) {
        return new AjaxEventBehavior("onclick"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                AjaxFallbackLink.this.onClick(target);
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new CancelEventIfNoAjaxDecorator(AjaxFallbackLink.this.getAjaxCallDecorator());
            }

            protected void onComponentTag(ComponentTag tag) {
                if (AjaxFallbackLink.this.isLinkEnabled()) {
                    super.onComponentTag(tag);
                }
            }

            protected AjaxChannel getChannel() {
                return AjaxFallbackLink.this.getChannel();
            }
        };
    }

    protected AjaxChannel getChannel() {
        return null;
    }

    protected IAjaxCallDecorator getAjaxCallDecorator() {
        return null;
    }

    @Override
    public final void onClick() {
        this.onClick(null);
    }

    @Override
    public abstract void onClick(AjaxRequestTarget var1);
}

