/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationOptions {
    public static final String OP_SCOPE = "SCOPE";
    public static final String SCOPE_OBJECT = "object";
    public static final String SCOPE_ONE_LEVEL = "onelevel";
    public static final String SCOPE_SUBTREE = "subtree";
    public static final String OP_CONTAINER = "CONTAINER";
    public static final String OP_RUN_AS_USER = "RUN_AS_USER";
    public static final String OP_RUN_WITH_PASSWORD = "RUN_WITH_PASSWORD";
    public static final String OP_ATTRIBUTES_TO_GET = "ATTRS_TO_GET";
    private final Map<String, Object> _operationOptions;

    public OperationOptions(Map<String, Object> operationOptions) {
        for (Object value : operationOptions.values()) {
            FrameworkUtil.checkOperationOptionValue(value);
        }
        Map operationOptionsClone = (Map)SerializerUtil.cloneObject(operationOptions);
        this._operationOptions = CollectionUtil.asReadOnlyMap(operationOptionsClone);
    }

    public Map<String, Object> getOptions() {
        return this._operationOptions;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("OperationOptions: ").append(this.getOptions());
        return bld.toString();
    }

    public String getScope() {
        return (String)this._operationOptions.get(OP_SCOPE);
    }

    public QualifiedUid getContainer() {
        return (QualifiedUid)this._operationOptions.get(OP_CONTAINER);
    }

    public String[] getAttributesToGet() {
        return (String[])this._operationOptions.get(OP_ATTRIBUTES_TO_GET);
    }

    public String getRunAsUser() {
        return (String)this._operationOptions.get(OP_RUN_AS_USER);
    }

    public GuardedString getRunWithPassword() {
        return (GuardedString)this._operationOptions.get(OP_RUN_WITH_PASSWORD);
    }
}

