/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectClassInfo {
    private final String _type;
    private final Set<AttributeInfo> _info;
    private final boolean _isContainer;

    public ObjectClassInfo(String type, Set<AttributeInfo> attrInfo, boolean isContainer) {
        Assertions.nullCheck(type, "type");
        this._type = type;
        this._info = CollectionUtil.newReadOnlySet(attrInfo);
        this._isContainer = isContainer;
        Map<String, AttributeInfo> map = AttributeInfoUtil.toMap(attrInfo);
        if (!map.containsKey(Name.NAME)) {
            String MSG = "Missing 'Name' attribute info.";
            throw new IllegalArgumentException("Missing 'Name' attribute info.");
        }
    }

    public boolean isContainer() {
        return this._isContainer;
    }

    public Set<AttributeInfo> getAttributeInfo() {
        return CollectionUtil.newReadOnlySet(this._info);
    }

    public String getType() {
        return this._type;
    }

    public final boolean is(String name) {
        return NameUtil.namesEqual(this._type, name);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ObjectClassInfo other = (ObjectClassInfo)obj;
        if (!this.is(other.getType())) {
            return false;
        }
        if (!CollectionUtil.equals(this.getAttributeInfo(), other.getAttributeInfo())) {
            return false;
        }
        return !this._isContainer != other._isContainer;
    }

    public int hashCode() {
        return NameUtil.nameHashCode(this._type);
    }

    public String toString() {
        return SerializerUtil.serializeXmlObject(this, false);
    }
}

