/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    private CollectionUtil() {
        throw new AssertionError();
    }

    public static SortedSet<String> newCaseInsensitiveSet() {
        TreeSet<String> rv = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        return rv;
    }

    public static boolean isCaseInsensitiveSet(Set<?> set) {
        SortedSet sortedSet;
        Comparator comp;
        return set instanceof SortedSet && ((Object)(comp = (sortedSet = (SortedSet)set).comparator())).equals(String.CASE_INSENSITIVE_ORDER);
    }

    public static <T> SortedMap<String, T> newCaseInsensitiveMap() {
        TreeMap rv = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        return rv;
    }

    public static boolean isCaseInsensitiveMap(Map<?, ?> map) {
        SortedMap sortedMap;
        Comparator comp;
        return map instanceof SortedMap && ((Object)(comp = (sortedMap = (SortedMap)map).comparator())).equals(String.CASE_INSENSITIVE_ORDER);
    }

    public static <T> Collection<T> nullAsEmpty(Collection<T> c) {
        return c == null ? new HashSet() : c;
    }

    public static <T, K> Map<T, K> nullAsEmpty(Map<T, K> map) {
        return map == null ? new HashMap() : map;
    }

    public static <T> Set<T> nullAsEmpty(Set<T> set) {
        return set == null ? new HashSet() : set;
    }

    public static <T> List<T> nullAsEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    public static <T> boolean isEmpty(Collection<T> c) {
        return c == null || c.isEmpty();
    }

    public static <T> Collection<T> unique(Collection<T> c) {
        return Collections.unmodifiableSet(CollectionUtil.newSet(c));
    }

    public static <T, K> Map<T, K> newReadOnlyMap(Map<T, K> map) {
        return Collections.unmodifiableMap(new HashMap<T, K>(CollectionUtil.nullAsEmpty(map)));
    }

    public static <T, K> Map<T, K> asReadOnlyMap(Map<T, K> map) {
        if (map instanceof SortedMap) {
            SortedMap sortedMap = (SortedMap)map;
            return Collections.unmodifiableSortedMap(sortedMap);
        }
        return Collections.unmodifiableMap(CollectionUtil.nullAsEmpty(map));
    }

    public static <T> Map<T, T> newReadOnlyMap(T[][] kv) {
        HashMap<T, T> map = new HashMap<T, T>();
        for (int i = 0; kv != null && i < kv.length; ++i) {
            T key = kv[i][0];
            T value = kv[i][1];
            map.put(key, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T, K> Map<T, K> newMapFromLists(List<T> keys, List<K> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException();
        }
        HashMap<T, K> map = new HashMap<T, K>(keys.size());
        Iterator<T> keyIter = keys.iterator();
        Iterator<K> valueIter = values.iterator();
        while (keyIter.hasNext() && valueIter.hasNext()) {
            T key = keyIter.next();
            K value = valueIter.next();
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> newMap(Properties properties) {
        HashMap<String, String> rv = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            rv.put((String)entry.getKey(), (String)entry.getValue());
        }
        return rv;
    }

    public static <T, K> Map<T, K> newMap(T k0, K v0) {
        HashMap<T, K> map = new HashMap<T, K>();
        map.put(k0, v0);
        return map;
    }

    public static <T, K> Map<T, K> newMap(T k0, K v0, T k1, K v1) {
        Map<T, T> map = CollectionUtil.newMap(k0, v0);
        map.put(k1, v1);
        return map;
    }

    public static <T, K> Map<T, K> newMap(T k0, K v0, T k1, K v1, T k2, K v2) {
        Map<T, T> map = CollectionUtil.newMap(k0, v0, k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <T, K> Map<T, K> newMap(T k0, K v0, T k1, K v1, T k2, K v2, T k3, K v3) {
        Map<T, T> map = CollectionUtil.newMap(k0, v0, k1, v1, k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <T, K> Map<T, K> newMap(T k0, K v0, T k1, K v1, T k2, K v2, T k3, K v3, T k4, K v4) {
        Map<T, T> map = CollectionUtil.newMap(k0, v0, k1, v1, k2, v2, k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <T, K> Map<T, K> newMap(T k0, K v0, T k1, K v1, T k2, K v2, T k3, K v3, T k4, K v4, T k5, K v5) {
        Map<T, T> map = CollectionUtil.newMap(k0, v0, k1, v1, k2, v2, k3, v3, k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <T, K> Map<T, K> newMap(T[] k, K[] v) {
        if (k.length != v.length) {
            throw new IllegalArgumentException();
        }
        HashMap<T, K> map = new HashMap<T, K>(k.length);
        for (int i = 0; i < k.length; ++i) {
            T key = k[i];
            K value = v[i];
            map.put(key, value);
        }
        return map;
    }

    public static <T> Set<T> newSet(Collection<T> c) {
        return new HashSet<T>(CollectionUtil.nullAsEmpty(c));
    }

    public static <T> Set<T> newSet(T ... arr) {
        HashSet<T> ret = new HashSet<T>();
        if (arr != null && arr.length != 0) {
            for (T t : arr) {
                ret.add(t);
            }
        }
        return ret;
    }

    public static <T> Set<T> newReadOnlySet(T ... arr) {
        return Collections.unmodifiableSet(CollectionUtil.newSet(arr));
    }

    public static <T> Set<T> newReadOnlySet(Collection<T> c) {
        return Collections.unmodifiableSet(CollectionUtil.newSet(c));
    }

    public static <T> Set<T> union(Collection<T> c1, Collection<T> c2) {
        Set<T> union = CollectionUtil.newSet(c1);
        union.addAll(c2);
        return Collections.unmodifiableSet(union);
    }

    public static <T> Set<T> intersection(Collection<T> c1, Collection<T> c2) {
        Set<T> intersection = CollectionUtil.newSet(c1);
        intersection.retainAll(c2);
        return Collections.unmodifiableSet(intersection);
    }

    public static <T> List<T> newSortedList(Collection<? extends T> col) {
        List<? extends T> list = CollectionUtil.newList(col);
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> newList(Collection<? extends T> c) {
        return new ArrayList<T>(CollectionUtil.nullAsEmpty(c));
    }

    public static <T> List<T> newList(T ... arr) {
        ArrayList<T> ret = new ArrayList<T>();
        if (arr != null && arr.length != 0) {
            for (T t : arr) {
                ret.add(t);
            }
        }
        return ret;
    }

    public static <T> List<T> newReadOnlyList(List<? extends T> list) {
        ArrayList<? extends T> l = new ArrayList<T>(CollectionUtil.nullAsEmpty(list));
        return Collections.unmodifiableList(l);
    }

    public static <T> List<T> newReadOnlyList(T ... obj) {
        return Collections.unmodifiableList(CollectionUtil.newList(obj));
    }

    public static <T> List<T> newReadOnlyList(Collection<? extends T> c) {
        return Collections.unmodifiableList(CollectionUtil.newList(c));
    }

    public static <T> List<T> asReadOnlyList(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> int forceCompare(Object o1, Object o2) {
        Comparable t1 = (Comparable)o1;
        Object t2 = o2;
        return t1.compareTo(t2);
    }

    public static int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            int rv = 0;
            for (int i = 0; i < length; ++i) {
                Object el = Array.get(o, i);
                rv += CollectionUtil.hashCode(el);
            }
            return rv;
        }
        if (o instanceof Collection) {
            Collection l = (Collection)o;
            int rv = 0;
            for (Object el : l) {
                rv += CollectionUtil.hashCode(el);
            }
            return rv;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return CollectionUtil.hashCode(map.values());
        }
        return o.hashCode();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        if (o1.getClass().isArray()) {
            int length2;
            Class<?> clazz2;
            Class<?> clazz1 = o1.getClass();
            if (!clazz1.equals(clazz2 = o2.getClass())) {
                return false;
            }
            int length1 = Array.getLength(o1);
            if (length1 != (length2 = Array.getLength(o2))) {
                return false;
            }
            for (int i = 0; i < length1; ++i) {
                Object el2;
                Object el1 = Array.get(o1, i);
                if (CollectionUtil.equals(el1, el2 = Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        if (o1 instanceof List) {
            if (o2 instanceof List) {
                List l1 = (List)o1;
                List l2 = (List)o2;
                if (l1.size() != l2.size()) {
                    return false;
                }
                for (int i = 0; i < l1.size(); ++i) {
                    Object el2;
                    Object el1 = l1.get(i);
                    if (CollectionUtil.equals(el1, el2 = l2.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o1 instanceof Set) {
            if (o2 instanceof Set) {
                return o1.equals(o2);
            }
            return false;
        }
        if (o1 instanceof Map) {
            if (o2 instanceof Map) {
                Map m1 = (Map)o1;
                Map m2 = (Map)o2;
                if (m1.size() != m2.size()) {
                    return false;
                }
                for (Map.Entry entry1 : m1.entrySet()) {
                    Object key1 = entry1.getKey();
                    Object val1 = entry1.getValue();
                    if (!m2.containsKey(key1)) {
                        return false;
                    }
                    Object val2 = m2.get(key1);
                    if (CollectionUtil.equals(val1, val2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return o1.equals(o2);
    }
}

