/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf;

import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskBinding;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.WorkflowManager;
import com.evolveum.midpoint.wf.wrappers.WfProcessWrapper;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelOperationStageType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelOperationStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskExecutionStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessVariable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WfTaskUtil {
    @Autowired(required=true)
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private WorkflowManager workflowManager;
    @Autowired(required=true)
    private PrismContext prismContext;
    private static final Trace LOGGER = TraceManager.getTrace(WfTaskUtil.class);
    public static final String WORKFLOW_EXTENSION_NS = "http://midpoint.evolveum.com/xml/ns/public/model/workflow-1.xsd";
    private static final boolean USE_WFSTATUS = true;
    public static final QName WFSTATUS_PROPERTY_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/model/workflow-1.xsd", "wfStatus");
    private PrismPropertyDefinition wfStatusPropertyDefinition;
    public static final QName WFLASTVARIABLES_PROPERTY_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/model/workflow-1.xsd", "wfLastVariables");
    private PrismPropertyDefinition wfLastVariablesPropertyDefinition;
    public static final QName WFPROCESS_WRAPPER_PROPERTY_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/model/workflow-1.xsd", "wfProcessWrapper");
    private PrismPropertyDefinition wfProcessWrapperPropertyDefinition;
    public static final QName WFPROCESSID_PROPERTY_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/model/workflow-1.xsd", "wfProcessId");
    private PrismPropertyDefinition wfProcessIdPropertyDefinition;

    @PostConstruct
    public void prepareDefinitions() {
        this.wfStatusPropertyDefinition = new PrismPropertyDefinition(WFSTATUS_PROPERTY_NAME, WFSTATUS_PROPERTY_NAME, DOMUtil.XSD_STRING, this.prismContext);
        this.wfStatusPropertyDefinition.setMaxOccurs(-1);
        this.wfStatusPropertyDefinition.setMinOccurs(0);
        this.wfLastVariablesPropertyDefinition = new PrismPropertyDefinition(WFLASTVARIABLES_PROPERTY_NAME, WFLASTVARIABLES_PROPERTY_NAME, DOMUtil.XSD_STRING, this.prismContext);
        this.wfLastVariablesPropertyDefinition.setMinOccurs(0);
        this.wfLastVariablesPropertyDefinition.setMaxOccurs(1);
        this.wfProcessWrapperPropertyDefinition = new PrismPropertyDefinition(WFPROCESS_WRAPPER_PROPERTY_NAME, WFPROCESS_WRAPPER_PROPERTY_NAME, DOMUtil.XSD_STRING, this.prismContext);
        this.wfProcessWrapperPropertyDefinition.setMinOccurs(0);
        this.wfProcessWrapperPropertyDefinition.setMaxOccurs(1);
        this.wfProcessIdPropertyDefinition = new PrismPropertyDefinition(WFPROCESSID_PROPERTY_NAME, WFPROCESSID_PROPERTY_NAME, DOMUtil.XSD_STRING, this.prismContext);
        this.wfProcessIdPropertyDefinition.setMinOccurs(0);
        this.wfProcessIdPropertyDefinition.setMaxOccurs(1);
    }

    void prepareActiveTask(Task t, String taskName, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        if (StringUtils.isEmpty((String)t.getName())) {
            t.setName(taskName);
        }
        t.pushHandlerUri("http://evolveum.com/wf-shadow-task-uri");
        t.setCategory("Workflow");
        t.setBinding(TaskBinding.LOOSE);
        t.makeRecurrentSimple(this.workflowManager.getWfConfiguration().getProcessCheckInterval());
        t.makeRunnable();
        t.setOwner(this.repositoryService.getObject(UserType.class, "00000000-0000-0000-0000-000000000002", parentResult));
        t.savePendingModifications(parentResult);
    }

    void preparePassiveTask(Task t, String taskName, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        if (StringUtils.isEmpty((String)t.getName())) {
            t.setName(taskName);
        }
        t.pushHandlerUri("http://evolveum.com/wf-shadow-task-uri");
        t.setCategory("Workflow");
        t.makeSingle();
        t.makeWaiting();
        t.savePendingModifications(parentResult);
    }

    void setWfProcessId(Task task, String pid, OperationResult parentResult) {
        String oid = task.getOid();
        Validate.notEmpty((String)oid, (String)"Task oid must not be null or empty (task must be persistent).");
        LOGGER.info("Setting wf process id = " + pid + " for task " + oid);
        this.setExtensionProperty(task, this.wfProcessIdPropertyDefinition, pid, parentResult);
    }

    String getLastVariables(Task task) {
        PrismProperty p = task.getExtension(WFLASTVARIABLES_PROPERTY_NAME);
        if (p == null) {
            return null;
        }
        return (String)p.getValue(String.class).getValue();
    }

    private void setExtensionProperty(Task task, PrismPropertyDefinition propertyDef, String propertyValue, OperationResult parentResult) {
        if (parentResult == null) {
            parentResult = new OperationResult("setExtensionProperty");
        }
        PrismProperty prop = propertyDef.instantiate();
        prop.setValue(new PrismPropertyValue((Object)propertyValue));
        try {
            task.setExtensionPropertyImmediate(prop, parentResult);
        }
        catch (ObjectNotFoundException ex) {
            parentResult.recordFatalError("Object not found", (Throwable)ex);
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot set process ID for task {}", (Throwable)ex, (Object[])new Object[]{task});
        }
        catch (SchemaException ex) {
            parentResult.recordFatalError("Schema error", (Throwable)ex);
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot set process ID for task {}", (Throwable)ex, (Object[])new Object[]{task});
        }
        catch (RuntimeException ex) {
            parentResult.recordFatalError("Internal error", (Throwable)ex);
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot set process ID for task {}", (Throwable)ex, (Object[])new Object[]{task});
        }
    }

    void recordProcessState(Task task, String description, String details, WfProcessInstanceEventType event, OperationResult parentResult) {
        LOGGER.info("recordProcessState starting.");
        String oid = task.getOid();
        Validate.notEmpty((String)oid, (String)"Task oid must not be null or empty (task must be persistent).");
        if (parentResult == null) {
            parentResult = new OperationResult("recordProcessState");
        }
        Date d = new Date();
        DateFormat df = DateFormat.getDateTimeInstance();
        String descriptionTsDt = "[" + d.getTime() + ": " + df.format(d) + "] " + description;
        String descriptionDt = "[" + df.format(d) + "] " + description;
        try {
            String currentVariables;
            String lastVariables;
            ObjectModificationType modification = new ObjectModificationType();
            modification.setOid(oid);
            task.setDescription(description);
            boolean recordStatus = true;
            if (event != null && event.isAnswerToQuery() && (lastVariables = this.getLastVariables(task)) != null && lastVariables.equals(currentVariables = this.dumpVariables(event))) {
                LOGGER.info("skipping inserting record, as current variables == last variables: " + currentVariables);
                recordStatus = false;
            }
            if (recordStatus) {
                PrismProperty wfStatusProperty = this.wfStatusPropertyDefinition.instantiate();
                PrismPropertyValue newValue = new PrismPropertyValue((Object)descriptionTsDt);
                wfStatusProperty.addValue(newValue);
                task.addExtensionProperty(wfStatusProperty);
                OperationResult or = task.getResult();
                String ordump = or == null ? null : or.dump();
                LOGGER.info("-------------------------------------------------------------------");
                LOGGER.info("Original operation result: " + ordump);
                if (or == null) {
                    or = new OperationResult("Task");
                }
                OperationResult sub = or.createSubresult(descriptionDt);
                sub.recordStatus(OperationResultStatus.SUCCESS, details);
                LOGGER.info("-------------------------------------------------------------------");
                LOGGER.info("Setting new operation result: " + or.dump());
                task.setResult(or);
            }
            if (event != null) {
                PrismProperty wfLastVariablesProperty = this.wfLastVariablesPropertyDefinition.instantiate();
                String variables = this.dumpVariables(event);
                wfLastVariablesProperty.setValue(new PrismPropertyValue((Object)variables));
                task.setExtensionProperty(wfLastVariablesProperty);
            }
            task.savePendingModifications(parentResult);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)("Couldn't record information from WfMS into task " + oid), (Throwable)ex, (Object[])new Object[0]);
            parentResult.recordFatalError("Couldn't record information from WfMS into task " + oid, (Throwable)ex);
        }
        LOGGER.info("recordProcessState ending.");
    }

    void markTaskAsClosed(Task task, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        String oid = task.getOid();
        try {
            PropertyDelta delta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(TaskType.class)), (QName)TaskType.F_EXECUTION_STATUS, (Object[])new Object[]{TaskExecutionStatusType.CLOSED});
            ArrayList<PropertyDelta> deltas = new ArrayList<PropertyDelta>();
            deltas.add(delta);
            this.repositoryService.modifyObject(TaskType.class, oid, deltas, parentResult);
        }
        catch (ObjectNotFoundException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)("Cannot mark task " + task + " as closed."), (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)("Cannot mark task " + task + " as closed."), (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        catch (ObjectAlreadyExistsException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)("Cannot mark task " + task + " as closed."), (Throwable)e, (Object[])new Object[0]);
            throw new SystemException((Throwable)e);
        }
    }

    String dumpVariables(WfProcessInstanceEventType event) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (event.getWfAnswer() != null) {
            sb.append("[answer from workflow: " + event.getWfAnswer() + "] ");
        }
        TreeMap<String, String> variables = new TreeMap<String, String>();
        for (WfProcessVariable wfProcessVariable : event.getWfProcessVariable()) {
            if (wfProcessVariable.getName().startsWith("midpoint")) continue;
            variables.put(wfProcessVariable.getName(), wfProcessVariable.getValue());
        }
        for (Map.Entry entry : variables.entrySet()) {
            if (!first) {
                sb.append("; ");
            }
            sb.append(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
            first = false;
        }
        return sb.toString();
    }

    public void setProcessWrapper(Task task, WfProcessWrapper wrapper) throws SchemaException {
        PrismProperty w = this.wfProcessWrapperPropertyDefinition.instantiate();
        w.setRealValue((Object)wrapper.getClass().getName());
        task.setExtensionProperty(w);
    }

    public WfProcessWrapper getProcessWrapper(Task task, List<WfProcessWrapper> wrappers) {
        String wrapperClassName = (String)task.getExtension(WFPROCESS_WRAPPER_PROPERTY_NAME).getRealValue(String.class);
        if (wrapperClassName == null) {
            throw new IllegalStateException("No wf process wrapper defined in task " + task);
        }
        for (WfProcessWrapper w : wrappers) {
            if (!wrapperClassName.equals(w.getClass().getName())) continue;
            return w;
        }
        throw new IllegalStateException("Wrapper " + wrapperClassName + " is not registered.");
    }

    public Map<String, String> unwrapWfVariables(WfProcessInstanceEventType event) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (WfProcessVariable var : event.getWfProcessVariable()) {
            retval.put(var.getName(), var.getValue());
        }
        return retval;
    }

    public String getWfVariable(WfProcessInstanceEventType event, String name) {
        for (WfProcessVariable v : event.getWfProcessVariable()) {
            if (!name.equals(v.getName())) continue;
            return v.getValue();
        }
        return null;
    }

    public void markRejection(Task task, OperationResult result) throws ObjectNotFoundException, SchemaException {
        ModelOperationStateType state = task.getModelOperationState();
        state.setStage(null);
        task.setModelOperationState(state);
        try {
            task.savePendingModifications(result);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
        this.markTaskAsClosed(task, result);
    }

    public void markAcceptation(Task task, OperationResult result) throws ObjectNotFoundException, SchemaException {
        ModelOperationStateType state = task.getModelOperationState();
        ModelOperationStageType stage = state.getStage();
        switch (state.getStage()) {
            case PRIMARY: {
                stage = ModelOperationStageType.SECONDARY;
                break;
            }
            case SECONDARY: {
                stage = ModelOperationStageType.EXECUTE;
                break;
            }
            case EXECUTE: {
                stage = null;
                break;
            }
            default: {
                throw new SystemException("Unknown model operation stage: " + state.getStage());
            }
        }
        state.setStage(stage);
        task.setModelOperationState(state);
        try {
            task.savePendingModifications(result);
        }
        catch (ObjectAlreadyExistsException ex) {
            throw new SystemException((Throwable)ex);
        }
        this.markTaskAsClosed(task, result);
    }
}

