/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http.handler;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.http.WebResponse;

public class RedirectRequestHandler
implements IRequestHandler {
    private final String redirectUrl;
    private final int status;

    public RedirectRequestHandler(String redirectUrl) {
        this(redirectUrl, 302);
    }

    public RedirectRequestHandler(String redirectUrl, int status) {
        if (status != 301 && status != 302) {
            throw new IllegalStateException("Status must be either 301 or 302, but was: " + status);
        }
        this.redirectUrl = redirectUrl;
        this.status = status;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public int getStatus() {
        return this.status;
    }

    public void detach(IRequestCycle requestCycle) {
    }

    public void respond(IRequestCycle requestCycle) {
        String location = this.redirectUrl.startsWith("/") ? requestCycle.getUrlRenderer().renderContextRelativeUrl(this.redirectUrl) : this.redirectUrl;
        WebResponse response = (WebResponse)requestCycle.getResponse();
        if (this.status == 302) {
            response.sendRedirect(location);
        } else {
            response.setStatus(301);
            response.setHeader("Location", location);
        }
    }
}

