/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.util.List;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationReader;
import org.apache.ibatis.migration.commands.BaseCommand;

public class UpCommand
extends BaseCommand {
    private boolean runOneStepOnly = false;

    public UpCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    public UpCommand(File repository, String environment, boolean force, boolean runOneStepOnly) {
        super(repository, environment, force);
        this.runOneStepOnly = runOneStepOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String ... params) {
        try {
            Change lastChange = null;
            if (this.changelogExists()) {
                lastChange = this.getLastAppliedChange();
            }
            List<Change> migrations = this.getMigrations();
            int steps = 0;
            for (Change change : migrations) {
                if (lastChange != null && change.getId().compareTo(lastChange.getId()) <= 0) continue;
                this.printStream.println(this.horizontalLine("Applying: " + change.getFilename(), 80));
                ScriptRunner runner = this.getScriptRunner();
                try {
                    runner.runScript(new MigrationReader(this.scriptFileReader(this.scriptFile(change.getFilename())), false, this.environmentProperties()));
                }
                finally {
                    runner.closeConnection();
                }
                this.insertChangelog(change);
                this.printStream.println();
                int limit = this.getStepCountParameter(Integer.MAX_VALUE, params);
                if (++steps != limit && !this.runOneStepOnly) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new MigrationException("Error executing command.  Cause: " + e, e);
        }
    }
}

