/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultMap {
    private String id;
    private Class type;
    private List<ResultMapping> resultMappings;
    private List<ResultMapping> idResultMappings;
    private List<ResultMapping> constructorResultMappings;
    private List<ResultMapping> propertyResultMappings;
    private Set<String> mappedColumns;
    private Discriminator discriminator;
    private boolean hasNestedResultMaps;

    private ResultMap() {
    }

    public String getId() {
        return this.id;
    }

    public boolean hasNestedResultMaps() {
        return this.hasNestedResultMaps;
    }

    public Class getType() {
        return this.type;
    }

    public List<ResultMapping> getResultMappings() {
        return this.resultMappings;
    }

    public List<ResultMapping> getConstructorResultMappings() {
        return this.constructorResultMappings;
    }

    public List<ResultMapping> getPropertyResultMappings() {
        return this.propertyResultMappings;
    }

    public List<ResultMapping> getIdResultMappings() {
        return this.idResultMappings;
    }

    public Set<String> getMappedColumns() {
        return this.mappedColumns;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public void forceNestedResultMaps() {
        this.hasNestedResultMaps = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ResultMap resultMap = new ResultMap();

        public Builder(Configuration configuration, String id, Class type, List<ResultMapping> resultMappings) {
            this.resultMap.id = id;
            this.resultMap.type = type;
            this.resultMap.resultMappings = resultMappings;
        }

        public Builder discriminator(Discriminator discriminator) {
            this.resultMap.discriminator = discriminator;
            return this;
        }

        public Class type() {
            return this.resultMap.type;
        }

        public ResultMap build() {
            this.resultMap.mappedColumns = new HashSet();
            this.resultMap.idResultMappings = new ArrayList();
            this.resultMap.constructorResultMappings = new ArrayList();
            this.resultMap.propertyResultMappings = new ArrayList();
            for (ResultMapping resultMapping : this.resultMap.resultMappings) {
                this.resultMap.hasNestedResultMaps = this.resultMap.hasNestedResultMaps || resultMapping.getNestedResultMapId() != null;
                String column = resultMapping.getColumn();
                if (column != null) {
                    this.resultMap.mappedColumns.add(column.toUpperCase(Locale.ENGLISH));
                } else if (resultMapping.isCompositeResult()) {
                    for (ResultMapping compositeResultMapping : resultMapping.getComposites()) {
                        String compositeColumn = compositeResultMapping.getColumn();
                        if (compositeColumn == null) continue;
                        this.resultMap.mappedColumns.add(compositeColumn.toUpperCase(Locale.ENGLISH));
                    }
                }
                if (resultMapping.getFlags().contains((Object)ResultFlag.CONSTRUCTOR)) {
                    this.resultMap.constructorResultMappings.add(resultMapping);
                } else {
                    this.resultMap.propertyResultMappings.add(resultMapping);
                }
                if (!resultMapping.getFlags().contains((Object)ResultFlag.ID)) continue;
                this.resultMap.idResultMappings.add(resultMapping);
            }
            if (this.resultMap.idResultMappings.isEmpty()) {
                this.resultMap.idResultMappings.addAll(this.resultMap.resultMappings);
            }
            this.resultMap.resultMappings = Collections.unmodifiableList(this.resultMap.resultMappings);
            this.resultMap.idResultMappings = Collections.unmodifiableList(this.resultMap.idResultMappings);
            this.resultMap.constructorResultMappings = Collections.unmodifiableList(this.resultMap.constructorResultMappings);
            this.resultMap.propertyResultMappings = Collections.unmodifiableList(this.resultMap.propertyResultMappings);
            this.resultMap.mappedColumns = Collections.unmodifiableSet(this.resultMap.mappedColumns);
            return this.resultMap;
        }
    }
}

