/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;
import org.apache.ibatis.cache.decorators.FifoCache;
import org.apache.ibatis.cache.decorators.LoggingCache;
import org.apache.ibatis.cache.decorators.ScheduledCache;
import org.apache.ibatis.cache.decorators.SerializedCache;
import org.apache.ibatis.cache.decorators.SynchronizedCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.reflection.MetaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBuilder {
    private String id;
    private Class<? extends Cache> implementation;
    private List<Class<? extends Cache>> decorators;
    private Integer size;
    private Long clearInterval;
    private boolean readWrite;
    private Properties properties;

    public CacheBuilder(String id) {
        this.id = id;
        this.decorators = new ArrayList<Class<? extends Cache>>();
    }

    public CacheBuilder implementation(Class<? extends Cache> implementation) {
        this.implementation = implementation;
        return this;
    }

    public CacheBuilder addDecorator(Class<? extends Cache> decorator) {
        if (decorator != null) {
            this.decorators.add(decorator);
        }
        return this;
    }

    public CacheBuilder size(Integer size) {
        this.size = size;
        return this;
    }

    public CacheBuilder clearInterval(Long clearInterval) {
        this.clearInterval = clearInterval;
        return this;
    }

    public CacheBuilder readWrite(boolean readWrite) {
        this.readWrite = readWrite;
        return this;
    }

    public CacheBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Cache build() {
        this.setDefaultImplementations();
        Cache cache = this.newBaseCacheInstance(this.implementation, this.id);
        this.setCacheProperties(cache);
        for (Class<? extends Cache> decorator : this.decorators) {
            cache = this.newCacheDecoratorInstance(decorator, cache);
            this.setCacheProperties(cache);
        }
        cache = this.setStandardDecorators(cache);
        return cache;
    }

    private void setDefaultImplementations() {
        if (this.implementation == null) {
            this.implementation = PerpetualCache.class;
            if (this.decorators.size() == 0) {
                this.decorators.add(FifoCache.class);
            }
        }
    }

    private Cache setStandardDecorators(Cache cache) {
        try {
            if (cache.getClass().getName().startsWith("org.apache.ibatis")) {
                MetaObject metaCache = MetaObject.forObject(cache);
                if (this.size != null && metaCache.hasSetter("size")) {
                    metaCache.setValue("size", this.size);
                }
                if (this.clearInterval != null) {
                    cache = new ScheduledCache(cache);
                    ((ScheduledCache)cache).setClearInterval(this.clearInterval);
                }
                if (this.readWrite) {
                    cache = new SerializedCache(cache);
                }
                cache = new LoggingCache(cache);
                cache = new SynchronizedCache(cache);
            }
            return cache;
        }
        catch (Exception e) {
            throw new CacheException("Error building standard cache decorators.  Cause: " + e, e);
        }
    }

    private void setCacheProperties(Cache cache) {
        if (this.properties != null) {
            MetaObject metaCache = MetaObject.forObject(cache);
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!metaCache.hasSetter(name)) continue;
                Class type = metaCache.getSetterType(name);
                if (String.class == type) {
                    metaCache.setValue(name, value);
                    continue;
                }
                if (Integer.TYPE == type || Integer.class == type) {
                    metaCache.setValue(name, Integer.valueOf(value));
                    continue;
                }
                if (Long.TYPE == type || Long.class == type) {
                    metaCache.setValue(name, Long.valueOf(value));
                    continue;
                }
                if (Short.TYPE == type || Short.class == type) {
                    metaCache.setValue(name, Short.valueOf(value));
                    continue;
                }
                if (Byte.TYPE == type || Byte.class == type) {
                    metaCache.setValue(name, Byte.valueOf(value));
                    continue;
                }
                if (Float.TYPE == type || Float.class == type) {
                    metaCache.setValue(name, Float.valueOf(value));
                    continue;
                }
                if (Double.TYPE == type || Double.class == type) {
                    metaCache.setValue(name, Double.valueOf(value));
                    continue;
                }
                throw new CacheException("Unsupported property type for cache: '" + name + "' of type " + type);
            }
        }
    }

    private Cache newBaseCacheInstance(Class<? extends Cache> cacheClass, String id) {
        Constructor<? extends Cache> cacheConstructor = this.getBaseCacheConstructor(cacheClass);
        try {
            return cacheConstructor.newInstance(id);
        }
        catch (Exception e) {
            throw new CacheException("Could not instantiate cache implementation (" + cacheClass + "). Cause: " + e, e);
        }
    }

    private Constructor<? extends Cache> getBaseCacheConstructor(Class<? extends Cache> cacheClass) {
        try {
            return cacheClass.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new CacheException("Invalid base cache implementation (" + cacheClass + ").  " + "Base cache implementations must have a constructor that takes a String id as a parameter.  Cause: " + e, e);
        }
    }

    private Cache newCacheDecoratorInstance(Class<? extends Cache> cacheClass, Cache base) {
        Constructor<? extends Cache> cacheConstructor = this.getCacheDecoratorConstructor(cacheClass);
        try {
            return cacheConstructor.newInstance(base);
        }
        catch (Exception e) {
            throw new CacheException("Could not instantiate cache decorator (" + cacheClass + "). Cause: " + e, e);
        }
    }

    private Constructor<? extends Cache> getCacheDecoratorConstructor(Class<? extends Cache> cacheClass) {
        try {
            return cacheClass.getConstructor(Cache.class);
        }
        catch (Exception e) {
            throw new CacheException("Invalid cache decorator (" + cacheClass + ").  " + "Cache decorators must have a constructor that takes a Cache instance as a parameter.  Cause: " + e, e);
        }
    }
}

