/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.logging.jdbc.PreparedStatementLogger;
import org.apache.ibatis.logging.jdbc.StatementLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public class ConnectionLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(Connection.class);
    private Connection connection;

    private ConnectionLogger(Connection conn) {
        this.connection = conn;
        if (log.isDebugEnabled()) {
            log.debug("ooo Connection Opened");
        }
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if ("prepareStatement".equals(method.getName())) {
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogger.newInstance(stmt, (String)params[0]);
                return stmt;
            }
            if ("prepareCall".equals(method.getName())) {
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogger.newInstance(stmt, (String)params[0]);
                return stmt;
            }
            if ("createStatement".equals(method.getName())) {
                Statement stmt = (Statement)method.invoke((Object)this.connection, params);
                stmt = StatementLogger.newInstance(stmt);
                return stmt;
            }
            if ("close".equals(method.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("xxx Connection Closed");
                }
                return method.invoke((Object)this.connection, params);
            }
            return method.invoke((Object)this.connection, params);
        }
        catch (Throwable t) {
            Throwable t1 = ExceptionUtil.unwrapThrowable(t);
            log.error("Error calling Connection." + method.getName() + ':', t1);
            throw t1;
        }
    }

    public static Connection newInstance(Connection conn) {
        ConnectionLogger handler = new ConnectionLogger(conn);
        ClassLoader cl = Connection.class.getClassLoader();
        return (Connection)Proxy.newProxyInstance(cl, new Class[]{Connection.class}, (InvocationHandler)handler);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

