/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.cache;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure1;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure11;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure13;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure15;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure17;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure19;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure21;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure3;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure5;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure7;
import com.evolveum.midpoint.repo.cache.RepositoryCache$AjcClosure9;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.ConcurrencyException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class RepositoryCache
implements RepositoryService {
    private static ThreadLocal<Map<String, PrismObject<ObjectType>>> cacheInstance;
    private static ThreadLocal<Integer> cacheCount;
    private RepositoryService repository;
    private static final Trace LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        RepositoryCache.ajc$preClinit();
        cacheInstance = new ThreadLocal();
        cacheCount = new ThreadLocal();
        LOGGER = TraceManager.getTrace(RepositoryCache.class);
    }

    public RepositoryCache() {
    }

    public RepositoryCache(RepositoryService repository) {
        this.setRepository(repository);
    }

    public void setRepository(RepositoryService service) {
        Validate.notNull((Object)service, (String)"Repository service must not be null.");
        this.repository = service;
    }

    private static Map<String, PrismObject<ObjectType>> getCache() {
        Integer count = cacheCount.get();
        if (count == null || count == 0) {
            return null;
        }
        Map<String, PrismObject<ObjectType>> inst = cacheInstance.get();
        if (inst == null) {
            LOGGER.trace("Cache: creating for thread {}", (Object)Thread.currentThread().getName());
            inst = new HashMap<String, PrismObject<ObjectType>>();
            cacheInstance.set(inst);
        }
        return inst;
    }

    public static void init() {
    }

    public static boolean exists() {
        return cacheInstance.get() != null;
    }

    public static void destroy() {
        Map<String, PrismObject<ObjectType>> inst = cacheInstance.get();
        if (inst != null) {
            LOGGER.trace("Cache: DESTROY for thread {}", (Object)Thread.currentThread().getName());
            cacheInstance.set(null);
        }
    }

    public static void enter() {
        Map<String, PrismObject<ObjectType>> inst = cacheInstance.get();
        Integer count = cacheCount.get();
        LOGGER.trace("Cache: ENTER for thread {}, {}", (Object)Thread.currentThread().getName(), (Object)count);
        if (inst == null) {
            inst = new HashMap<String, PrismObject<ObjectType>>();
            cacheInstance.set(inst);
        }
        if (count == null) {
            count = 0;
        }
        cacheCount.set(count + 1);
    }

    public static void exit() {
        Integer count = cacheCount.get();
        LOGGER.trace("Cache: EXIT for thread {}, {}", (Object)Thread.currentThread().getName(), (Object)count);
        if (count == null || count == 0) {
            LOGGER.error("Cache: Attempt to exit cache with count {}", (Object)count);
        } else {
            cacheCount.set(count - 1);
            if (count <= 1) {
                RepositoryCache.destroy();
            }
        }
    }

    public static String dump() {
        StringBuilder sb = new StringBuilder("Cache ");
        if (RepositoryCache.exists()) {
            sb.append("exists ");
        } else {
            sb.append("doesn't exist ");
        }
        sb.append(", count ");
        if (cacheCount.get() == null) {
            sb.append("null");
        } else {
            sb.append(cacheCount.get());
        }
        sb.append(", ");
        if (cacheInstance.get() == null) {
            sb.append("null content");
        } else {
            sb.append(cacheInstance.get().entrySet().size());
            sb.append(" entries");
        }
        return sb.toString();
    }

    public <T extends ObjectType> PrismObject<T> getObject(Class<T> type, String oid, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        Class<T> clazz = type;
        String string = oid;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private boolean isCacheable(Class<?> type) {
        if (type.equals(TaskType.class)) {
            return false;
        }
        return !ResourceObjectShadowType.class.isAssignableFrom(type);
    }

    public <T extends ObjectType> String addObject(PrismObject<T> object, OperationResult parentResult) throws ObjectAlreadyExistsException, SchemaException {
        PrismObject<T> prismObject = object;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, prismObject, (Object)operationResult);
        Object[] objectArray = new Object[]{this, prismObject, operationResult, joinPoint};
        return (String)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> List<PrismObject<T>> listObjects(Class<T> type, PagingType paging, OperationResult parentResult) {
        Class<T> clazz = type;
        PagingType pagingType = paging;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> List<PrismObject<T>> searchObjects(Class<T> type, QueryType query, PagingType paging, OperationResult parentResult) throws SchemaException {
        Class<T> clazz = type;
        QueryType queryType = query;
        PagingType pagingType = paging;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, queryType, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> int countObjects(Class<T> type, QueryType query, OperationResult parentResult) throws SchemaException {
        Class<T> clazz = type;
        QueryType queryType = query;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, queryType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, operationResult, joinPoint};
        return Conversions.intValue((Object)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    public <T extends ObjectType> void modifyObject(Class<T> type, String oid, Collection<? extends ItemDelta> modifications, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        Class<T> clazz = type;
        String string = oid;
        Collection<? extends ItemDelta> collection = modifications;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, collection, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, collection, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> void deleteObject(Class<T> type, String oid, OperationResult parentResult) throws ObjectNotFoundException {
        Class<T> clazz = type;
        String string = oid;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public PrismObject<UserType> listAccountShadowOwner(String accountOid, OperationResult parentResult) throws ObjectNotFoundException {
        String string = accountOid;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)operationResult);
        Object[] objectArray = new Object[]{this, string, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    public <T extends ResourceObjectShadowType> List<PrismObject<T>> listResourceObjectShadows(String resourceOid, Class<T> resourceObjectShadowType, OperationResult parentResult) throws ObjectNotFoundException {
        String string = resourceOid;
        Class<T> clazz = resourceObjectShadowType;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{string, clazz, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, clazz, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public void claimTask(String oid, OperationResult parentResult) throws ObjectNotFoundException, ConcurrencyException, SchemaException {
        String string = oid;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string, (Object)operationResult);
        Object[] objectArray = new Object[]{this, string, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void releaseTask(String oid, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        String string = oid;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string, (Object)operationResult);
        Object[] objectArray = new Object[]{this, string, operationResult, joinPoint};
        MidpointAspect.aspectOf().processRepositoryNdc(new RepositoryCache$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ PrismObject getObject_aroundBody0(RepositoryCache ajc$this, Class type, String oid, OperationResult parentResult, JoinPoint joinPoint) {
        if (!ajc$this.isCacheable(type)) {
            LOGGER.trace("Cache: PASS {} ({})", (Object)oid, (Object)type.getSimpleName());
            return ajc$this.repository.getObject(type, oid, parentResult);
        }
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache == null) {
            LOGGER.trace("Cache: NULL {} ({})", (Object)oid, (Object)type.getSimpleName());
        } else {
            if (cache.containsKey(oid)) {
                LOGGER.trace("Cache: HIT {} ({})", (Object)oid, (Object)type.getSimpleName());
                return cache.get(oid).clone();
            }
            LOGGER.trace("Cache: MISS {} ({})", (Object)oid, (Object)type.getSimpleName());
        }
        PrismObject object = ajc$this.repository.getObject(type, oid, parentResult);
        if (cache != null) {
            cache.put(oid, (PrismObject<ObjectType>)object.clone());
        }
        return object;
    }

    static final /* synthetic */ String addObject_aroundBody2(RepositoryCache ajc$this, PrismObject object, OperationResult parentResult, JoinPoint joinPoint) {
        String oid = ajc$this.repository.addObject(object, parentResult);
        return oid;
    }

    static final /* synthetic */ List listObjects_aroundBody4(RepositoryCache ajc$this, Class type, PagingType paging, OperationResult parentResult, JoinPoint joinPoint) {
        List objects = ajc$this.repository.listObjects(type, paging, parentResult);
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache != null) {
            for (PrismObject object : objects) {
                cache.put(object.getOid(), (PrismObject<ObjectType>)object);
            }
        }
        return objects;
    }

    static final /* synthetic */ List searchObjects_aroundBody6(RepositoryCache ajc$this, Class type, QueryType query, PagingType paging, OperationResult parentResult, JoinPoint joinPoint) {
        List objects = ajc$this.repository.searchObjects(type, query, paging, parentResult);
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache != null) {
            for (PrismObject object : objects) {
                cache.put(object.getOid(), (PrismObject<ObjectType>)object);
            }
        }
        return objects;
    }

    static final /* synthetic */ int countObjects_aroundBody8(RepositoryCache ajc$this, Class type, QueryType query, OperationResult parentResult, JoinPoint joinPoint) {
        return ajc$this.repository.countObjects(type, query, parentResult);
    }

    static final /* synthetic */ void modifyObject_aroundBody10(RepositoryCache ajc$this, Class type, String oid, Collection modifications, OperationResult parentResult, JoinPoint joinPoint) {
        ajc$this.repository.modifyObject(type, oid, modifications, parentResult);
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache != null) {
            cache.remove(oid);
        }
    }

    static final /* synthetic */ void deleteObject_aroundBody12(RepositoryCache ajc$this, Class type, String oid, OperationResult parentResult, JoinPoint joinPoint) {
        ajc$this.repository.deleteObject(type, oid, parentResult);
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache != null) {
            cache.remove(oid);
        }
    }

    static final /* synthetic */ PrismObject listAccountShadowOwner_aroundBody14(RepositoryCache ajc$this, String accountOid, OperationResult parentResult, JoinPoint joinPoint) {
        return ajc$this.repository.listAccountShadowOwner(accountOid, parentResult);
    }

    static final /* synthetic */ List listResourceObjectShadows_aroundBody16(RepositoryCache ajc$this, String resourceOid, Class resourceObjectShadowType, OperationResult parentResult, JoinPoint joinPoint) {
        return ajc$this.repository.listResourceObjectShadows(resourceOid, resourceObjectShadowType, parentResult);
    }

    static final /* synthetic */ void claimTask_aroundBody18(RepositoryCache ajc$this, String oid, OperationResult parentResult, JoinPoint joinPoint) {
        ajc$this.repository.claimTask(oid, parentResult);
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache != null) {
            cache.remove(oid);
        }
    }

    static final /* synthetic */ void releaseTask_aroundBody20(RepositoryCache ajc$this, String oid, OperationResult parentResult, JoinPoint joinPoint) {
        ajc$this.repository.releaseTask(oid, parentResult);
        Map<String, PrismObject<ObjectType>> cache = RepositoryCache.getCache();
        if (cache != null) {
            cache.remove(oid);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RepositoryCache.java", RepositoryCache.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.Class:java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "com.evolveum.midpoint.prism.PrismObject"), 159);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addObject", "com.evolveum.midpoint.repo.cache.RepositoryCache", "com.evolveum.midpoint.prism.PrismObject:com.evolveum.midpoint.schema.result.OperationResult", "object:parentResult", "com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException:com.evolveum.midpoint.util.exception.SchemaException", "java.lang.String"), 194);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "releaseTask", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "oid:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException", "void"), 283);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listObjects", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.Class:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "type:paging:parentResult", "", "java.util.List"), 205);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchObjects", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "type:query:paging:parentResult", "com.evolveum.midpoint.util.exception.SchemaException", "java.util.List"), 219);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countObjects", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.schema.result.OperationResult", "type:query:parentResult", "com.evolveum.midpoint.util.exception.SchemaException", "int"), 233);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "modifyObject", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.Class:java.lang.String:java.util.Collection:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:modifications:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException", "void"), 239);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteObject", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.Class:java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "void"), 251);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listAccountShadowOwner", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "accountOid:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "com.evolveum.midpoint.prism.PrismObject"), 261);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listResourceObjectShadows", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.String:java.lang.Class:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:resourceObjectShadowType:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "java.util.List"), 267);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "claimTask", "com.evolveum.midpoint.repo.cache.RepositoryCache", "java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "oid:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.ConcurrencyException:com.evolveum.midpoint.util.exception.SchemaException", "void"), 273);
    }
}

