/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.util;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CapabilitiesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectSynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SchemaHandlingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ActivationCapabilityType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.CredentialsCapabilityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Element;

public class ResourceTypeUtil {
    public static String getConnectorOid(ResourceType resource) {
        if (resource.getConnectorRef() != null) {
            return resource.getConnectorRef().getOid();
        }
        if (resource.getConnector() != null) {
            return resource.getConnector().getOid();
        }
        return null;
    }

    public static ConnectorType getConnectorType(ResourceType resource, ObjectResolver resolver, OperationResult parentResult) throws ObjectNotFoundException, SchemaException {
        if (resource.getConnector() != null) {
            return resource.getConnector();
        }
        if (resource.getConnectorRef() != null) {
            return resolver.resolve(resource.getConnectorRef(), ConnectorType.class, "resolving connector in " + resource, parentResult);
        }
        return null;
    }

    public static Element getResourceXsdSchema(ResourceType resource) {
        XmlSchemaType xmlSchemaType = resource.getSchema();
        if (xmlSchemaType == null) {
            return null;
        }
        return ObjectTypeUtil.findXsdElement(xmlSchemaType);
    }

    public static Element getResourceXsdSchema(PrismObject<ResourceType> resource) {
        PrismContainer xmlSchema = resource.findContainer(ResourceType.F_SCHEMA);
        if (xmlSchema == null) {
            return null;
        }
        return ObjectTypeUtil.findXsdElement((PrismContainer<XmlSchemaType>)xmlSchema);
    }

    public static void setResourceXsdSchema(ResourceType resourceType, Element xsdElement) {
        PrismObject resource = resourceType.asPrismObject();
        ResourceTypeUtil.setResourceXsdSchema((PrismObject<ResourceType>)resource, xsdElement);
    }

    public static void setResourceXsdSchema(PrismObject<ResourceType> resource, Element xsdElement) {
        try {
            PrismContainer schemaContainer = resource.findOrCreateContainer(ResourceType.F_SCHEMA);
            PrismProperty definitionProperty = schemaContainer.findOrCreateProperty(XmlSchemaType.F_DEFINITION);
            ObjectTypeUtil.setXsdSchemaDefinition((PrismProperty<Element>)definitionProperty, xsdElement);
        }
        catch (SchemaException e) {
            throw new IllegalStateException("Internal schema error: " + e.getMessage(), e);
        }
    }

    public static <T> T getCapability(Collection<Object> capabilities, Class<T> capabilityClass) {
        for (Object cap : capabilities) {
            if (cap instanceof JAXBElement) {
                JAXBElement jaxe = (JAXBElement)cap;
                if (!capabilityClass.isAssignableFrom(jaxe.getDeclaredType())) continue;
                return (T)jaxe.getValue();
            }
            if (!capabilityClass.isAssignableFrom(cap.getClass())) continue;
            return (T)cap;
        }
        return null;
    }

    public static <T> T getEffectiveCapability(ResourceType resource, Class<T> capabilityClass) {
        if (resource.getCapabilities() != null) {
            return ResourceTypeUtil.getCapability(resource.getCapabilities().getAny(), capabilityClass);
        }
        if (resource.getNativeCapabilities() != null && resource.getNativeCapabilities().getCapabilities() != null) {
            return ResourceTypeUtil.getCapability(resource.getNativeCapabilities().getCapabilities().getAny(), capabilityClass);
        }
        return null;
    }

    public static List<Object> listEffectiveCapabilities(ResourceType resource) {
        if (resource.getCapabilities() != null) {
            return resource.getCapabilities().getAny();
        }
        if (resource.getNativeCapabilities() != null && resource.getNativeCapabilities().getCapabilities() != null) {
            return resource.getNativeCapabilities().getCapabilities().getAny();
        }
        return new ArrayList<Object>();
    }

    public static String getCapabilityDisplayName(Object capability) {
        String className = null;
        className = capability instanceof JAXBElement ? ((JAXBElement)capability).getDeclaredType().getSimpleName() : capability.getClass().getSimpleName();
        if (className.endsWith("CapabilityType")) {
            return className.substring(0, className.length() - "CapabilityType".length());
        }
        return className;
    }

    public static CapabilitiesType getEffectiveCapabilities(ResourceType resource) {
        if (resource.getCapabilities() != null) {
            return resource.getCapabilities();
        }
        if (resource.getNativeCapabilities() != null && resource.getNativeCapabilities().getCapabilities() != null) {
            return resource.getNativeCapabilities().getCapabilities();
        }
        return new CapabilitiesType();
    }

    public static boolean hasActivationCapability(ResourceType resource) {
        return ResourceTypeUtil.getEffectiveCapability(resource, ActivationCapabilityType.class) != null;
    }

    public static boolean hasCredentialsCapability(ResourceType resource) {
        return ResourceTypeUtil.getEffectiveCapability(resource, CredentialsCapabilityType.class) != null;
    }

    public static boolean hasResourceNativeActivationCapability(ResourceType resource) {
        ActivationCapabilityType activationCapability = null;
        if (resource.getNativeCapabilities() != null && resource.getNativeCapabilities().getCapabilities() != null) {
            activationCapability = ResourceTypeUtil.getCapability(resource.getNativeCapabilities().getCapabilities().getAny(), ActivationCapabilityType.class);
        }
        return activationCapability != null;
    }

    public static ResourceAccountTypeDefinitionType getResourceAccountTypeDefinitionType(ResourceType resource, String accountType) {
        if (resource == null) {
            throw new IllegalArgumentException("The resource is null");
        }
        SchemaHandlingType schemaHandling = resource.getSchemaHandling();
        if (schemaHandling == null || schemaHandling.getAccountType() == null) {
            return null;
        }
        for (ResourceAccountTypeDefinitionType acct : schemaHandling.getAccountType()) {
            if (accountType == null && acct.isDefault().booleanValue()) {
                return acct;
            }
            if (!acct.getName().equals(accountType)) continue;
            return acct;
        }
        return null;
    }

    public static ObjectSynchronizationType determineSynchronization(ResourceType resource, Class<UserType> type) {
        SynchronizationType synchronization = resource.getSynchronization();
        if (synchronization == null) {
            return null;
        }
        List<ObjectSynchronizationType> objectSynchronizations = synchronization.getObjectSynchronization();
        if (objectSynchronizations.isEmpty()) {
            return null;
        }
        if (objectSynchronizations.size() == 1) {
            return objectSynchronizations.get(0);
        }
        throw new UnsupportedOperationException("Selecting from multiple synchronization settings is not yet supported");
    }

    public static PrismContainer<Containerable> getConfigurationContainer(ResourceType resourceType) {
        return ResourceTypeUtil.getConfigurationContainer((PrismObject<ResourceType>)resourceType.asPrismObject());
    }

    public static PrismContainer<Containerable> getConfigurationContainer(PrismObject<ResourceType> resource) {
        return resource.findContainer(ResourceType.F_CONFIGURATION);
    }

    public static String getResourceNamespace(PrismObject<ResourceType> resource) {
        return ResourceTypeUtil.getResourceNamespace((ResourceType)resource.asObjectable());
    }

    public static String getResourceNamespace(ResourceType resourceType) {
        if (resourceType.getNamespace() != null) {
            return resourceType.getNamespace();
        }
        return "http://midpoint.evolveum.com/xml/ns/public/resource/instance-2";
    }
}

