/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.util;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainer;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;

public class ResourceObjectShadowUtil {
    public static Collection<ResourceAttribute<?>> getIdentifiers(ResourceObjectShadowType shadowType) {
        return ResourceObjectShadowUtil.getIdentifiers((PrismObject<? extends ResourceObjectShadowType>)shadowType.asPrismObject());
    }

    public static Collection<ResourceAttribute<?>> getIdentifiers(PrismObject<? extends ResourceObjectShadowType> shadow) {
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer(shadow);
        if (attributesContainer == null) {
            return null;
        }
        return attributesContainer.getIdentifiers();
    }

    public static Collection<ResourceAttribute<?>> getAttributes(ResourceObjectShadowType shadowType) {
        return ResourceObjectShadowUtil.getAttributes((PrismObject<? extends ResourceObjectShadowType>)shadowType.asPrismObject());
    }

    public static Collection<ResourceAttribute<?>> getAttributes(PrismObject<? extends ResourceObjectShadowType> shadow) {
        return ResourceObjectShadowUtil.getAttributesContainer(shadow).getAttributes();
    }

    public static ResourceAttributeContainer getAttributesContainer(ResourceObjectShadowType shadowType) {
        return ResourceObjectShadowUtil.getAttributesContainer((PrismObject<? extends ResourceObjectShadowType>)shadowType.asPrismObject());
    }

    public static ResourceAttributeContainer getAttributesContainer(PrismObject<? extends ResourceObjectShadowType> shadow) {
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            return null;
        }
        if (attributesContainer instanceof ResourceAttributeContainer) {
            return (ResourceAttributeContainer)attributesContainer;
        }
        throw new SystemException("Expected that <attributes> will be ResourceAttributeContainer but it is " + attributesContainer.getClass());
    }

    public static ResourceAttributeContainer getOrCreateAttributesContainer(PrismObject<? extends ResourceObjectShadowType> shadow, ObjectClassComplexTypeDefinition objectClassDefinition) {
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer(shadow);
        if (attributesContainer != null) {
            return attributesContainer;
        }
        ResourceAttributeContainer emptyContainer = ResourceAttributeContainer.createEmptyContainer(ResourceObjectShadowType.F_ATTRIBUTES, objectClassDefinition);
        try {
            shadow.add((Item)emptyContainer);
        }
        catch (SchemaException e) {
            throw new SystemException("Unexpected schema error: " + e.getMessage(), (Throwable)e);
        }
        return emptyContainer;
    }

    public static ResourceAttributeContainerDefinition getObjectClassDefinition(ResourceObjectShadowType shadow) {
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer(shadow);
        return attributesContainer.getDefinition();
    }

    public static String getResourceOid(ResourceObjectShadowType shadowType) {
        PrismObject shadow = shadowType.asPrismObject();
        PrismReference resourceRef = shadow.findReference(ResourceObjectShadowType.F_RESOURCE_REF);
        if (resourceRef == null) {
            return null;
        }
        return resourceRef.getOid();
    }

    public static String getSingleStringAttributeValue(ResourceObjectShadowType shadow, QName attrName) {
        return ResourceObjectShadowUtil.getSingleStringAttributeValue((PrismObject<ResourceObjectShadowType>)shadow.asPrismObject(), attrName);
    }

    private static String getSingleStringAttributeValue(PrismObject<ResourceObjectShadowType> shadow, QName attrName) {
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            return null;
        }
        PrismProperty attribute = attributesContainer.findProperty(attrName);
        if (attribute == null) {
            return null;
        }
        return (String)attribute.getRealValue();
    }

    public static String getMultiStringAttributeValueAsSingle(ResourceObjectShadowType shadow, QName attrName) {
        return ResourceObjectShadowUtil.getMultiStringAttributeValueAsSingle((PrismObject<ResourceObjectShadowType>)shadow.asPrismObject(), attrName);
    }

    private static String getMultiStringAttributeValueAsSingle(PrismObject<ResourceObjectShadowType> shadow, QName attrName) {
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            return null;
        }
        PrismProperty attribute = attributesContainer.findProperty(attrName);
        if (attribute == null) {
            return null;
        }
        Collection realValues = attribute.getRealValues();
        if (realValues == null || realValues.isEmpty()) {
            return null;
        }
        if (realValues.size() > 1) {
            throw new IllegalStateException("More than one value in attribute " + attrName);
        }
        return (String)realValues.iterator().next();
    }

    public static List<Object> getAttributeValues(ResourceObjectShadowType shadowType, QName attrName) {
        return ResourceObjectShadowUtil.getAttributeValues((PrismObject<ResourceObjectShadowType>)shadowType.asPrismObject(), attrName);
    }

    public static List<Object> getAttributeValues(PrismObject<ResourceObjectShadowType> shadow, QName attrName) {
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null || attributesContainer.isEmpty()) {
            return null;
        }
        PrismProperty attr = attributesContainer.findProperty(attrName);
        if (attr == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (PrismPropertyValue pval : attr.getValues()) {
            values.add(pval.getValue());
        }
        if (values.isEmpty()) {
            return null;
        }
        return values;
    }

    public static void setPassword(AccountShadowType accountShadowType, ProtectedStringType password) {
        PasswordType passwordType;
        CredentialsType credentialsType = accountShadowType.getCredentials();
        if (credentialsType == null) {
            credentialsType = new CredentialsType();
            accountShadowType.setCredentials(credentialsType);
        }
        if ((passwordType = credentialsType.getPassword()) == null) {
            passwordType = new PasswordType();
            credentialsType.setPassword(passwordType);
        }
        passwordType.setProtectedString(password);
    }

    public static ActivationType getOrCreateActivation(ResourceObjectShadowType shadowType) {
        ActivationType activation = shadowType.getActivation();
        if (activation == null) {
            activation = new ActivationType();
            shadowType.setActivation(activation);
        }
        return activation;
    }

    public static void fixShadow(PrismObject<? extends ResourceObjectShadowType> shadow, ResourceSchema resourceSchema) throws SchemaException {
        PrismContainer attributesContainer = shadow.findContainer(ResourceObjectShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            return;
        }
        if (attributesContainer instanceof ResourceAttributeContainer) {
            if (attributesContainer.getDefinition() != null) {
                return;
            }
            throw new SchemaException("No definition for attributes container in " + shadow);
        }
        ObjectClassComplexTypeDefinition objectClassDefinition = ResourceObjectShadowUtil.determineObjectClassDefinition(shadow, resourceSchema);
        ResourceAttributeContainer convertedContainer = ResourceAttributeContainer.convertFromContainer(attributesContainer, objectClassDefinition);
        shadow.getValue().replace((Item)attributesContainer, (Item)convertedContainer);
    }

    private static ObjectClassComplexTypeDefinition determineObjectClassDefinition(PrismObject<? extends ResourceObjectShadowType> shadow, ResourceSchema resourceSchema) throws SchemaException {
        QName objectClassName = ((ResourceObjectShadowType)shadow.asObjectable()).getObjectClass();
        if (objectClassName == null) {
            throw new SchemaException("No object class specified in shadow " + shadow);
        }
        ObjectClassComplexTypeDefinition objectClassDefinition = resourceSchema.findObjectClassDefinition(objectClassName);
        if (objectClassDefinition == null) {
            throw new SchemaException("No definition for object class " + objectClassName + " as specified in shadow " + shadow);
        }
        return objectClassDefinition;
    }

    public static void applyResourceSchema(PrismObject<? extends ResourceObjectShadowType> shadow, ResourceSchema resourceSchema) throws SchemaException {
        ResourceObjectShadowType shadowType = (ResourceObjectShadowType)shadow.asObjectable();
        QName objectClass = shadowType.getObjectClass();
        ObjectClassComplexTypeDefinition objectClassDefinition = resourceSchema.findObjectClassDefinition(objectClass);
        ResourceObjectShadowUtil.applyObjectClass(shadow, objectClassDefinition);
    }

    private static void applyObjectClass(PrismObject<? extends ResourceObjectShadowType> shadow, ObjectClassComplexTypeDefinition objectClassDefinition) throws SchemaException {
        PrismContainer attributesContainer = shadow.findContainer(AccountShadowType.F_ATTRIBUTES);
        ResourceAttributeContainerDefinition racDef = new ResourceAttributeContainerDefinition(AccountShadowType.F_ATTRIBUTES, objectClassDefinition, objectClassDefinition.getPrismContext());
        attributesContainer.applyDefinition((ItemDefinition)racDef, true);
    }
}

