/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.holder;

import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.xml.GlobalDynamicNamespacePrefixMapper;
import com.evolveum.midpoint.schema.holder.TrivialXPathParser;
import com.evolveum.midpoint.schema.holder.XPathSegment;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathHolder {
    private static final Trace LOGGER = TraceManager.getTrace(XPathHolder.class);
    public static final String DEFAULT_PREFIX = "c";
    private boolean absolute;
    private List<XPathSegment> segments;
    Map<String, String> explicitNamespaceDeclarations;

    public XPathHolder() {
        this.absolute = false;
        this.segments = new ArrayList<XPathSegment>();
    }

    public XPathHolder(String xpath) {
        this.parse(xpath, null, null);
    }

    public XPathHolder(String xpath, Map<String, String> namespaceMap) {
        this.parse(xpath, null, namespaceMap);
    }

    public XPathHolder(List<XPathSegment> segments) {
        this(segments, false);
    }

    public XPathHolder(List<XPathSegment> segments, boolean absolute) {
        this.segments = new ArrayList<XPathSegment>();
        for (XPathSegment segment : segments) {
            if (StringUtils.isEmpty((String)segment.getQName().getPrefix())) {
                QName qname = segment.getQName();
                this.segments.add(new XPathSegment(new QName(qname.getNamespaceURI(), qname.getLocalPart(), DEFAULT_PREFIX)));
                continue;
            }
            this.segments.add(segment);
        }
        this.absolute = absolute;
    }

    public XPathHolder(Element domElement) {
        String xpath = ".";
        if (domElement != null) {
            xpath = domElement.getTextContent();
        }
        this.parse(xpath, domElement, null);
    }

    public XPathHolder(String xpath, Node domNode) {
        this.parse(xpath, domNode, null);
    }

    public XPathHolder(QName ... segmentQNames) {
        this.segments = new ArrayList<XPathSegment>();
        QName[] qNameArray = segmentQNames;
        int n = segmentQNames.length;
        int n2 = 0;
        while (n2 < n) {
            QName segmentQName = qNameArray[n2];
            XPathSegment segment = new XPathSegment(segmentQName);
            this.segments.add(segment);
            ++n2;
        }
        this.absolute = false;
    }

    public XPathHolder(PropertyPath propertyPath) {
        this.segments = new ArrayList<XPathSegment>();
        for (PropertyPathSegment segment : propertyPath.getSegments()) {
            XPathSegment xsegment = new XPathSegment(segment.getName());
            this.segments.add(xsegment);
        }
        this.absolute = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String xpath, Node domNode, Map<String, String> namespaceMap) {
        this.segments = new ArrayList<XPathSegment>();
        this.absolute = false;
        if (".".equals(xpath)) {
            return;
        }
        TrivialXPathParser parser = TrivialXPathParser.parse(xpath);
        this.explicitNamespaceDeclarations = parser.getNamespaceMap();
        xpath = parser.getPureXPathString();
        String[] segArray = xpath.split("/");
        int i = 0;
        while (i < segArray.length) {
            if (segArray[i] == null || segArray[i].isEmpty()) {
                if (i != 0) throw new IllegalStateException("XPath " + xpath + " has an empty segment (number " + i + ")");
                this.absolute = true;
            } else {
                QName qname;
                String namespace;
                String[] qnameArray;
                String segmentStr = segArray[i];
                boolean variable = false;
                if (segmentStr.startsWith("$")) {
                    variable = true;
                    segmentStr = segmentStr.substring(1);
                }
                if ((qnameArray = segmentStr.split(":")).length > 2) {
                    throw new IllegalStateException("Unsupported format: more than one colon in XPath segment: " + segArray[i]);
                }
                if (qnameArray.length == 1 || qnameArray[1] == null || qnameArray[1].isEmpty()) {
                    namespace = this.findNamespace(null, domNode, namespaceMap);
                    qname = new QName(namespace, qnameArray[0], DEFAULT_PREFIX);
                } else {
                    namespace = this.findNamespace(qnameArray[0], domNode, namespaceMap);
                    qname = new QName(namespace, qnameArray[1], qnameArray[0]);
                }
                if (StringUtils.isEmpty((String)qname.getNamespaceURI())) {
                    LOGGER.debug("WARNING: Namespace was not defined for {} in xpath\n{}", new Object[]{segmentStr, xpath});
                }
                XPathSegment segment = new XPathSegment(qname, variable);
                this.segments.add(segment);
            }
            ++i;
        }
    }

    private String findNamespace(String prefix, Node domNode, Map<String, String> namespaceMap) {
        String ns = null;
        if (this.explicitNamespaceDeclarations != null && (ns = prefix == null ? this.explicitNamespaceDeclarations.get("") : this.explicitNamespaceDeclarations.get(prefix)) != null) {
            return ns;
        }
        if (namespaceMap != null && (ns = prefix == null ? namespaceMap.get("") : namespaceMap.get(prefix)) != null) {
            return ns;
        }
        if (domNode != null && (ns = prefix == null || prefix.isEmpty() ? domNode.lookupNamespaceURI(null) : domNode.lookupNamespaceURI(prefix)) != null) {
            return ns;
        }
        if (ns == null && (DEFAULT_PREFIX.equals(prefix) || prefix == null)) {
            return "http://midpoint.evolveum.com/xml/ns/public/common/common-2";
        }
        return ns;
    }

    public String getXPath() {
        StringBuilder sb = new StringBuilder();
        this.addPureXpath(sb);
        return sb.toString();
    }

    public String getXPathWithDeclarations() {
        StringBuilder sb = new StringBuilder();
        this.addExplicitNsDeclarations(sb);
        this.addPureXpath(sb);
        return sb.toString();
    }

    private void addPureXpath(StringBuilder sb) {
        if (!this.absolute && this.segments.isEmpty()) {
            sb.append(".");
            return;
        }
        if (this.absolute) {
            sb.append("/");
        }
        Iterator<XPathSegment> iter = this.segments.iterator();
        while (iter.hasNext()) {
            QName qname;
            XPathSegment seg = iter.next();
            if (seg.isVariable()) {
                sb.append("$");
            }
            if ((qname = seg.getQName()).getPrefix() != null && !qname.getPrefix().isEmpty()) {
                sb.append(String.valueOf(qname.getPrefix()) + ":" + qname.getLocalPart());
            } else {
                sb.append("c:" + qname.getLocalPart());
            }
            if (!iter.hasNext()) continue;
            sb.append("/");
        }
    }

    public Map<String, String> getNamespaceMap() {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        for (XPathSegment seg : this.segments) {
            QName qname = seg.getQName();
            if (qname.getPrefix() != null && !qname.getPrefix().isEmpty()) {
                namespaceMap.put(qname.getPrefix(), qname.getNamespaceURI());
                continue;
            }
            namespaceMap.put(DEFAULT_PREFIX, qname.getNamespaceURI());
        }
        return namespaceMap;
    }

    public Element toElement(String elementNamespace, String localElementName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return this.toElement(elementNamespace, localElementName, loader.newDocument());
        }
        catch (ParserConfigurationException ex) {
            throw new AssertionError((Object)("Error on createing XML document " + ex.getMessage()));
        }
    }

    public Element toElement(QName elementQName, Document document) {
        return this.toElement(elementQName.getNamespaceURI(), elementQName.getLocalPart(), document);
    }

    public Element toElement(String elementNamespace, String localElementName, Document document) {
        Element e = document.createElementNS(elementNamespace, localElementName);
        e.setPrefix(GlobalDynamicNamespacePrefixMapper.getPreferredPrefix((String)elementNamespace));
        e.setTextContent(this.getXPath());
        Map<String, String> namespaceMap = this.getNamespaceMap();
        if (namespaceMap != null) {
            for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
                DOMUtil.setNamespaceDeclaration((Element)e, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return e;
    }

    public List<XPathSegment> toSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public XPathHolder transposedPath(QName parentPath) {
        XPathSegment segment = new XPathSegment(parentPath);
        ArrayList<XPathSegment> segments = new ArrayList<XPathSegment>();
        segments.add(segment);
        return this.transposedPath(segments);
    }

    public XPathHolder transposedPath(List<XPathSegment> parentPath) {
        ArrayList<XPathSegment> allSegments = new ArrayList<XPathSegment>();
        allSegments.addAll(parentPath);
        allSegments.addAll(this.toSegments());
        return new XPathHolder(allSegments);
    }

    public String toString() {
        return this.getXPath();
    }

    private void addExplicitNsDeclarations(StringBuilder sb) {
        if (this.explicitNamespaceDeclarations == null || this.explicitNamespaceDeclarations.isEmpty()) {
            return;
        }
        for (String prefix : this.explicitNamespaceDeclarations.keySet()) {
            sb.append("declare ");
            if (prefix.equals("")) {
                sb.append("default namespace '");
                sb.append(this.explicitNamespaceDeclarations.get(prefix));
                sb.append("'; ");
                sb.append("declare namespace ");
                sb.append(DEFAULT_PREFIX);
                sb.append("='");
                sb.append(this.explicitNamespaceDeclarations.get(prefix));
                sb.append("'; ");
                continue;
            }
            sb.append("namespace ");
            sb.append(prefix);
            sb.append("='");
            sb.append(this.explicitNamespaceDeclarations.get(prefix));
            sb.append("'; ");
        }
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.absolute ? 1231 : 1237);
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof QName) {
            if (this.segments.size() != 1) {
                return false;
            }
            XPathSegment segment = this.segments.get(0);
            return segment.getQName().equals((QName)obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathHolder other = (XPathHolder)obj;
        if (this.absolute != other.absolute) {
            return false;
        }
        return !(this.segments == null ? other.segments != null : !this.segments.equals(other.segments));
    }

    public boolean isBelow(XPathHolder path) {
        if (this.segments.size() < 1) {
            return false;
        }
        int i = 0;
        while (i < path.segments.size()) {
            if (i > this.segments.size()) {
                return false;
            }
            if (!this.segments.get(i).equals(path.segments.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<XPathSegment> getTail(XPathHolder path) {
        int i = 0;
        while (i < path.segments.size()) {
            if (i > this.segments.size()) {
                return null;
            }
            if (!this.segments.get(i).equals(path.segments.get(i))) {
                return null;
            }
            ++i;
        }
        return this.segments.subList(i, this.segments.size());
    }

    public static boolean isDefault(Element pathElement) {
        if (pathElement == null) {
            return true;
        }
        XPathHolder xpath = new XPathHolder(pathElement);
        return xpath.isEmpty();
    }

    public PropertyPath toPropertyPath() {
        List<XPathSegment> xsegments = this.toSegments();
        ArrayList<PropertyPathSegment> segments = new ArrayList<PropertyPathSegment>(xsegments.size());
        for (XPathSegment segment : xsegments) {
            QName qName = segment.getQName();
            String id = null;
            boolean variable = segment.isVariable();
            segments.add(new PropertyPathSegment(qName, id, variable));
        }
        return new PropertyPath(segments);
    }
}

