/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.holder;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrivialXPathParser {
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private String pureXPathString = "";

    private TrivialXPathParser() {
    }

    public static TrivialXPathParser parse(String xpath) {
        TrivialXPathParser parser = new TrivialXPathParser();
        String regexp = "(^|;)[\\s\\p{Z}]*declare[\\s\\p{Z}]+(default[\\s\\p{Z}]+)?namespace[\\s\\p{Z}]+((\\w+)[\\s\\p{Z}]*=[\\s\\p{Z}]*)?(['\"])([^'\"]*)\\5[\\s\\p{Z}]*(?=;)";
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(xpath);
        int lastEnd = 0;
        while (matcher.find()) {
            String prefix = matcher.group(4);
            String url = matcher.group(6);
            if (matcher.group(2) != null) {
                prefix = "";
            }
            parser.namespaceMap.put(prefix, url);
            lastEnd = matcher.end();
        }
        parser.pureXPathString = xpath;
        if (lastEnd > 0) {
            parser.pureXPathString = xpath.substring(lastEnd + 1).trim();
        }
        parser.pureXPathString = parser.pureXPathString.replaceFirst("^[\\p{Z}\\s]+", "").replaceFirst("[\\p{Z}\\s]+$", "");
        return parser;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }

    public String getPureXPathString() {
        return this.pureXPathString;
    }
}

