/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.schema.SchemaDefinitionFactory;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.util.PrismContextFactory;
import com.evolveum.midpoint.prism.xml.DynamicNamespacePrefixMapper;
import com.evolveum.midpoint.prism.xml.GlobalDynamicNamespacePrefixMapper;
import com.evolveum.midpoint.schema.processor.MidPointSchemaDefinitionFactory;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.xml.sax.SAXException;

public class MidPointPrismContextFactory
implements PrismContextFactory {
    private static final File TEST_EXTRA_SCHEMA_DIR = new File("src/test/resources/schema");
    public static final MidPointPrismContextFactory FACTORY = new MidPointPrismContextFactory(TEST_EXTRA_SCHEMA_DIR);
    private File extraSchemaDir;

    public MidPointPrismContextFactory() {
        this.extraSchemaDir = null;
    }

    public MidPointPrismContextFactory(File extraSchemaDir) {
        this.extraSchemaDir = extraSchemaDir;
    }

    public PrismContext createPrismContext() throws SchemaException, FileNotFoundException {
        SchemaRegistry schemaRegistry = this.createSchemaRegistry();
        PrismContext context = PrismContext.create((SchemaRegistry)schemaRegistry);
        context.setDefinitionFactory(this.createDefinitionFactory());
        return context;
    }

    private SchemaDefinitionFactory createDefinitionFactory() {
        return new MidPointSchemaDefinitionFactory();
    }

    public PrismContext createInitializedPrismContext() throws SchemaException, SAXException, IOException {
        PrismContext context = this.createPrismContext();
        context.initialize();
        return context;
    }

    private SchemaRegistry createSchemaRegistry() throws SchemaException, FileNotFoundException {
        SchemaRegistry schemaRegistry = new SchemaRegistry();
        schemaRegistry.setObjectSchemaNamespace("http://midpoint.evolveum.com/xml/ns/public/common/common-2");
        schemaRegistry.setNamespacePrefixMapper((DynamicNamespacePrefixMapper)new GlobalDynamicNamespacePrefixMapper());
        this.registerBuiltinSchemas(schemaRegistry);
        this.registerExtensionSchemas(schemaRegistry);
        return schemaRegistry;
    }

    protected void registerExtensionSchemas(SchemaRegistry schemaRegistry) throws SchemaException, FileNotFoundException {
        if (this.extraSchemaDir != null && this.extraSchemaDir.exists()) {
            schemaRegistry.registerPrismSchemasFromDirectory(this.extraSchemaDir);
        }
    }

    private void registerBuiltinSchemas(SchemaRegistry schemaRegistry) throws SchemaException {
        schemaRegistry.registerSchemaResource("xml/ns/standard/XMLSchema.xsd", "xsd");
        schemaRegistry.registerSchemaResource("xml/ns/standard/xmldsig-core-schema.xsd", "ds");
        schemaRegistry.registerSchemaResource("xml/ns/standard/xenc-schema.xsd", "enc");
        schemaRegistry.getNamespacePrefixMapper().registerPrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi", false);
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/annotation-2.xsd", "a");
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/types-2.xsd", "t", com.evolveum.prism.xml.ns._public.types_2.ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/query-2.xsd", "q", com.evolveum.prism.xml.ns._public.query_2.ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismDefaultSchemaResource("xml/ns/public/common/common-2.xsd", "c", ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/common/api-types-2.xsd", "apti", com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/resource/annotation-2.xsd", "ra");
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/resource/capabilities-2.xsd", "cap", com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/connector/icf-1/connector-schema-2.xsd", "icfc", com.evolveum.midpoint.xml.ns._public.connector.icf_1.connector_schema_2.ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/connector/icf-1/resource-schema-2.xsd", "icfs", com.evolveum.midpoint.xml.ns._public.connector.icf_1.resource_schema_2.ObjectFactory.class.getPackage());
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/model/import/extension-2.xsd", "impext");
        schemaRegistry.registerPrismSchemaResource("xml/ns/public/model/workflow-1.xsd", "wf");
    }

    private void setupDebug() {
        DebugUtil.setDefaultNamespacePrefix((String)"http://midpoint.evolveum.com/xml/ns/public");
    }
}

